/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.utilities;

import com.strobel.annotations.NotNull;
import com.strobel.annotations.Nullable;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.CompoundTypeReference;
import com.strobel.assembler.metadata.ConversionType;
import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataFilters;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataParser;
import com.strobel.assembler.metadata.MethodBinder;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.PrimitiveType;
import com.strobel.assembler.metadata.RawType;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.annotations.CustomAnnotation;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.java.ast.AnonymousObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.CastExpression;
import com.strobel.decompiler.languages.java.ast.ConditionalExpression;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.DepthFirstAstVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.IndexerExpression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.LambdaExpression;
import com.strobel.decompiler.languages.java.ast.LocalTypeDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.MethodGroupExpression;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.ParenthesizedExpression;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.ReturnStatement;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.SynchronizedStatement;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import com.strobel.decompiler.languages.java.utilities.TypeUtilities;
import com.strobel.decompiler.semantics.ResolveResult;
import com.strobel.functions.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class RedundantCastUtility {
    @NotNull
    public static List<CastExpression> getRedundantCastsInside(Function<AstNode, ResolveResult> resolver, AstNode site) {
        VerifyArgument.notNull(resolver, "resolver");
        if (site == null) {
            return Collections.emptyList();
        }
        CastCollector visitor = new CastCollector(resolver);
        site.acceptVisitor(visitor, null);
        return new ArrayList<CastExpression>(visitor.getFoundCasts());
    }

    public static boolean isCastRedundant(Function<AstNode, ResolveResult> resolver, CastExpression cast) {
        AstNode parent = RedundantCastUtility.skipParenthesesUp(cast.getParent());
        if (parent == null) {
            return false;
        }
        if (parent.getRole() == Roles.ARGUMENT || parent.isReference()) {
            parent = parent.getParent();
        }
        IsRedundantVisitor visitor = new IsRedundantVisitor(resolver, false);
        parent.acceptVisitor(visitor, null);
        return visitor.isRedundant();
    }

    public static void removeCast(CastExpression castExpression) {
        if (castExpression == null || castExpression.isNull()) {
            return;
        }
        Expression operand = castExpression.getExpression();
        if (operand instanceof ParenthesizedExpression) {
            operand = ((ParenthesizedExpression)operand).getExpression();
        }
        if (operand == null || operand.isNull()) {
            return;
        }
        AstNode toBeReplaced = castExpression;
        AstNode parent = castExpression.getParent();
        while (parent instanceof ParenthesizedExpression) {
            toBeReplaced = parent;
            parent = parent.getParent();
        }
        toBeReplaced.replaceWith(operand);
    }

    @Nullable
    private static Expression removeParentheses(Expression e) {
        Expression result = e;
        while (result instanceof ParenthesizedExpression) {
            result = ((ParenthesizedExpression)result).getExpression();
        }
        return result;
    }

    @Nullable
    private static AstNode skipParenthesesUp(AstNode e) {
        AstNode result = e;
        while (result instanceof ParenthesizedExpression) {
            result = result.getParent();
        }
        return result;
    }

    private static class IsRedundantVisitor
    extends DepthFirstAstVisitor<Void, Void> {
        private final boolean _isRecursive;
        private final Function<AstNode, ResolveResult> _resolver;
        private boolean _isRedundant;

        IsRedundantVisitor(Function<AstNode, ResolveResult> resolver, boolean recursive) {
            this._isRecursive = recursive;
            this._resolver = resolver;
        }

        public final boolean isRedundant() {
            return this._isRedundant;
        }

        @Override
        protected Void visitChildren(AstNode node, Void data) {
            if (this._isRecursive) {
                return (Void)super.visitChildren(node, data);
            }
            return null;
        }

        @Override
        public Void visitAssignmentExpression(AssignmentExpression node, Void data) {
            this.processPossibleTypeCast(node.getRight(), this.getType(node.getLeft()));
            return (Void)super.visitAssignmentExpression(node, data);
        }

        @Override
        public Void visitVariableDeclaration(VariableDeclarationStatement node, Void data) {
            TypeReference leftType = this.getType(node.getType());
            if (leftType != null) {
                for (VariableInitializer initializer : node.getVariables()) {
                    this.processPossibleTypeCast(initializer.getInitializer(), leftType);
                }
            }
            return (Void)super.visitVariableDeclaration(node, data);
        }

        @Override
        public Void visitFieldDeclaration(FieldDeclaration node, Void data) {
            TypeReference leftType = this.getType(node.getReturnType());
            if (leftType != null) {
                for (VariableInitializer initializer : node.getVariables()) {
                    this.processPossibleTypeCast(initializer.getInitializer(), leftType);
                }
            }
            return (Void)super.visitFieldDeclaration(node, data);
        }

        @Override
        public Void visitReturnStatement(ReturnStatement node, Void data) {
            MethodDeclaration methodDeclaration = CollectionUtilities.firstOrDefault(node.getAncestors(MethodDeclaration.class));
            if (methodDeclaration != null && !methodDeclaration.isNull()) {
                TypeReference returnType = this.getType(methodDeclaration.getReturnType());
                Expression returnValue = node.getExpression();
                if (returnType != null && returnValue != null && !returnValue.isNull()) {
                    this.processPossibleTypeCast(returnValue, returnType);
                }
            }
            return (Void)super.visitReturnStatement(node, data);
        }

        @Override
        public Void visitBinaryOperatorExpression(BinaryOperatorExpression node, Void data) {
            TypeReference leftType = this.getType(node.getLeft());
            TypeReference rightType = this.getType(node.getRight());
            this.processBinaryExpressionOperand(node.getLeft(), rightType, node.getOperator());
            this.processBinaryExpressionOperand(node.getRight(), leftType, node.getOperator());
            return (Void)super.visitBinaryOperatorExpression(node, data);
        }

        @Override
        public Void visitInvocationExpression(InvocationExpression node, Void data) {
            super.visitInvocationExpression(node, data);
            this.processCall(node);
            return null;
        }

        @Override
        public Void visitObjectCreationExpression(ObjectCreationExpression node, Void data) {
            for (Expression argument : node.getArguments()) {
                argument.acceptVisitor(this, data);
            }
            this.processCall(node);
            return null;
        }

        @Override
        public Void visitAnonymousObjectCreationExpression(AnonymousObjectCreationExpression node, Void data) {
            for (Expression argument : node.getArguments()) {
                argument.acceptVisitor(this, data);
            }
            this.processCall(node);
            return null;
        }

        @Override
        public Void visitCastExpression(CastExpression node, Void data) {
            Expression operand = node.getExpression();
            if (operand == null || operand.isNull()) {
                return null;
            }
            TypeReference topCastType = this.getType(node);
            if (topCastType == null) {
                return null;
            }
            Expression e = RedundantCastUtility.removeParentheses(operand);
            if (e instanceof CastExpression) {
                CastExpression innerCast = (CastExpression)e;
                TypeReference innerCastType = this.getType(innerCast.getType());
                if (innerCastType == null) {
                    return null;
                }
                Expression innerOperand = innerCast.getExpression();
                TypeReference innerOperandType = this.getType(innerOperand);
                if (!innerCastType.isPrimitive()) {
                    if (innerOperandType != null && MetadataHelper.getConversionType(topCastType, innerOperandType) != ConversionType.NONE) {
                        this.addToResults(innerCast, false);
                    }
                } else {
                    ConversionType valueToInner = MetadataHelper.getNumericConversionType(innerCastType, innerOperandType);
                    ConversionType outerToInner = MetadataHelper.getNumericConversionType(innerCastType, topCastType);
                    if (outerToInner == ConversionType.IDENTITY) {
                        if (valueToInner == ConversionType.IDENTITY) {
                            this.addToResults(node, false);
                            this.addToResults(innerCast, true);
                        } else {
                            this.addToResults(innerCast, true);
                        }
                    } else if (outerToInner == ConversionType.IMPLICIT) {
                        ConversionType valueToOuter = MetadataHelper.getNumericConversionType(topCastType, innerOperandType);
                        if (valueToOuter != ConversionType.NONE) {
                            this.addToResults(innerCast, true);
                        }
                    } else if (valueToInner == ConversionType.IMPLICIT && MetadataHelper.getNumericConversionType(topCastType, innerOperandType) == ConversionType.IMPLICIT) {
                        this.addToResults(innerCast, true);
                    }
                }
            } else {
                AstNode parent = node.getParent();
                if (parent instanceof ConditionalExpression) {
                    TypeReference conditionalType;
                    TypeReference operandType = this.getType(operand);
                    if (!MetadataHelper.isSameType(operandType, conditionalType = this.getType(parent), true)) {
                        if (!this.checkResolveAfterRemoveCast(parent)) {
                            return null;
                        }
                        Expression thenExpression = ((ConditionalExpression)parent).getTrueExpression();
                        Expression elseExpression = ((ConditionalExpression)parent).getFalseExpression();
                        Expression opposite = thenExpression == node ? elseExpression : thenExpression;
                        TypeReference oppositeType = this.getType(opposite);
                        if (oppositeType == null || !MetadataHelper.isSameType(conditionalType, oppositeType, true)) {
                            return null;
                        }
                    } else if (topCastType.isPrimitive() && !operandType.isPrimitive()) {
                        return null;
                    }
                } else {
                    if (parent instanceof SynchronizedStatement && this.getType(e) instanceof PrimitiveType) {
                        return null;
                    }
                    if (e instanceof LambdaExpression || e instanceof MethodGroupExpression) {
                        TypeReference functionalInterfaceType;
                        if (parent instanceof ParenthesizedExpression && parent.getParent() != null && parent.getParent().isReference()) {
                            return null;
                        }
                        ResolveResult lambdaResult = this._resolver.apply(e);
                        if (lambdaResult != null && lambdaResult.getType() != null) {
                            TypeReference asSubType = MetadataHelper.asSubType(lambdaResult.getType(), topCastType);
                            functionalInterfaceType = asSubType != null ? asSubType : lambdaResult.getType();
                        } else {
                            DynamicCallSite callSite = e.getUserData(Keys.DYNAMIC_CALL_SITE);
                            if (callSite == null) {
                                return null;
                            }
                            functionalInterfaceType = callSite.getMethodType().getReturnType();
                        }
                        if (!MetadataHelper.isAssignableFrom(topCastType, functionalInterfaceType, false)) {
                            return null;
                        }
                    }
                }
                this.processAlreadyHasTypeCast(node);
            }
            return (Void)super.visitCastExpression(node, data);
        }

        protected TypeReference getType(AstNode node) {
            ResolveResult result = this._resolver.apply(node);
            return result != null ? result.getType() : null;
        }

        @NotNull
        protected List<TypeReference> getTypes(AstNodeCollection<? extends AstNode> nodes) {
            if (nodes == null || nodes.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<TypeReference> types = new ArrayList<TypeReference>();
            for (AstNode astNode : nodes) {
                TypeReference nodeType = this.getType(astNode);
                if (nodeType == null) {
                    return Collections.emptyList();
                }
                types.add(nodeType);
            }
            return types;
        }

        protected void processPossibleTypeCast(Expression rightExpression, @Nullable TypeReference leftType) {
            TypeReference operandType;
            Expression castOperand;
            if (leftType == null) {
                return;
            }
            Expression r = RedundantCastUtility.removeParentheses(rightExpression);
            if (r instanceof CastExpression && (castOperand = ((CastExpression)r).getExpression()) != null && !castOperand.isNull() && (operandType = this.getType(castOperand)) != null) {
                if (MetadataHelper.isAssignableFrom(leftType, operandType, false)) {
                    this.addToResults((CastExpression)r, false);
                } else {
                    TypeReference unboxedLeftType = MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(leftType);
                    TypeReference unboxedOperandType = MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(operandType);
                    if (castOperand instanceof PrimitiveExpression && unboxedLeftType.getSimpleType().isIntegral() && unboxedLeftType.getSimpleType().isSubWordOrInt32() && MetadataHelper.isAssignableFrom(BuiltinTypes.Integer, unboxedOperandType, false)) {
                        this.addToResults((CastExpression)r, true);
                    }
                }
            }
        }

        protected void addToResults(@NotNull CastExpression cast, boolean force) {
            if (force || !this.isTypeCastSemantic(cast)) {
                this._isRedundant = true;
            }
        }

        protected void processBinaryExpressionOperand(Expression operand, TypeReference otherType, BinaryOperatorType op) {
            if (operand instanceof CastExpression) {
                CastExpression cast = (CastExpression)operand;
                Expression toCast = cast.getExpression();
                TypeReference castType = this.getType(cast);
                TypeReference innerType = this.getType(toCast);
                if (castType != null && innerType != null && TypeUtilities.isBinaryOperatorApplicable(op, innerType, otherType, false)) {
                    this.addToResults(cast, false);
                }
            }
        }

        protected void processCall(@NotNull Expression e) {
            int realParametersEnd;
            int i;
            TypeReference targetType;
            AstNodeCollection<Expression> arguments = e.getChildrenByRole(Roles.ARGUMENT);
            if (arguments.isEmpty()) {
                return;
            }
            MemberReference reference = e.getUserData(Keys.MEMBER_REFERENCE);
            if (reference == null && e.getParent() instanceof MemberReferenceExpression) {
                reference = e.getParent().getUserData(Keys.MEMBER_REFERENCE);
            }
            if (!(reference instanceof MethodReference)) {
                return;
            }
            MethodReference method = (MethodReference)reference;
            Expression target = e.getChildByRole(Roles.TARGET_EXPRESSION);
            if (target instanceof MemberReferenceExpression) {
                target = target.getChildByRole(Roles.TARGET_EXPRESSION);
            }
            if ((targetType = this.getType(target)) == null) {
                targetType = method.getDeclaringType();
            } else if (!(targetType instanceof RawType) && MetadataHelper.isRawType(targetType)) {
                targetType = MetadataHelper.eraseRecursive(targetType);
            } else {
                TypeReference asSuper = MetadataHelper.asSuper(method.getDeclaringType(), targetType);
                TypeReference asSubType = asSuper != null ? MetadataHelper.asSubType(method.getDeclaringType(), asSuper) : null;
                targetType = asSubType != null ? asSubType : targetType;
            }
            List<MethodReference> candidates = MetadataHelper.findMethods(targetType, MetadataFilters.matchName(method.getName()));
            MethodDefinition resolvedMethod = method.resolve();
            ArrayList<TypeReference> originalTypes = new ArrayList<TypeReference>();
            List<ParameterDefinition> parameters = method.getParameters();
            Expression lastArgument = arguments.lastOrNullObject();
            ArrayList<TypeReference> newTypes = null;
            int syntheticLeadingCount = 0;
            int syntheticTrailingCount = 0;
            for (ParameterDefinition parameter : parameters) {
                if (!parameter.isSynthetic()) break;
                ++syntheticLeadingCount;
                originalTypes.add(parameter.getParameterType());
            }
            int i2 = parameters.size() - 1;
            while (i2 >= 0 && parameters.get(i2).isSynthetic()) {
                --i2;
                ++syntheticTrailingCount;
            }
            for (Expression argument : arguments) {
                TypeReference argumentType = this.getType(argument);
                if (argumentType == null) {
                    return;
                }
                originalTypes.add(argumentType);
            }
            for (i = realParametersEnd = parameters.size() - syntheticTrailingCount; i < parameters.size(); ++i) {
                originalTypes.add(parameters.get(i).getParameterType());
            }
            i = syntheticLeadingCount;
            for (Expression a = arguments.firstOrNullObject(); i < realParametersEnd && a != null && !a.isNull(); a = a.getNextSibling(Roles.ARGUMENT), ++i) {
                boolean sameMethod;
                ParameterDefinition p;
                TypeReference parameterType;
                Expression arg = RedundantCastUtility.removeParentheses(a);
                if (!(arg instanceof CastExpression) || a == lastArgument && i == parameters.size() - 1 && resolvedMethod != null && resolvedMethod.isVarArgs()) continue;
                CastExpression cast = (CastExpression)arg;
                Expression castOperand = cast.getExpression();
                TypeReference castType = this.getType(cast);
                TypeReference operandType = this.getType(castOperand);
                if (castType == null || operandType == null || castType.isPrimitive() && !operandType.isPrimitive() && !(parameterType = (p = parameters.get(i)).getParameterType()).isPrimitive()) continue;
                if (newTypes == null) {
                    newTypes = new ArrayList<TypeReference>(originalTypes);
                } else {
                    newTypes.clear();
                    newTypes.addAll(originalTypes);
                }
                newTypes.set(i, operandType);
                MethodBinder.BindResult result = MethodBinder.selectMethod(candidates, newTypes);
                if (result.isFailure() || result.isAmbiguous() || !(sameMethod = StringUtilities.equals(method.getErasedSignature(), result.getMethod().getErasedSignature()))) continue;
                ParameterDefinition newParameter = result.getMethod().getParameters().get(i);
                if (castType.isPrimitive()) {
                    boolean castNeeded;
                    boolean bl = castNeeded = !MetadataHelper.isSameType(castType, MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(newParameter.getParameterType()));
                    if (castNeeded) continue;
                }
                if (!MetadataHelper.isAssignableFrom(newParameter.getParameterType(), castType)) continue;
                this.addToResults(cast, false);
            }
        }

        protected void processAlreadyHasTypeCast(CastExpression cast) {
            AstNode parent = cast.getParent();
            while (parent instanceof ParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (parent == null || cast.getRole() == Roles.ARGUMENT && !(parent instanceof IndexerExpression) || parent instanceof AssignmentExpression || parent instanceof ReturnStatement || parent instanceof CastExpression || parent instanceof BinaryOperatorExpression) {
                return;
            }
            if (this.isTypeCastSemantic(cast)) {
                return;
            }
            TypeReference castTo = this.getType(cast.getType());
            Expression operand = cast.getExpression();
            TypeReference operandType = this.getType(operand);
            if (castTo == null || operandType == null) {
                return;
            }
            TypeReference expectedType = TypeUtilities.getExpectedTypeByParent(this._resolver, cast);
            boolean isCharConversion = operandType == BuiltinTypes.Character ^ castTo == BuiltinTypes.Character;
            if (expectedType != null) {
                if (isCharConversion && !expectedType.isPrimitive()) {
                    return;
                }
                operandType = expectedType;
            } else if (isCharConversion) {
                return;
            }
            if (operandType == BuiltinTypes.Null && castTo.isPrimitive()) {
                return;
            }
            if (parent.isReference()) {
                if (operandType.isPrimitive() && !castTo.isPrimitive()) {
                    return;
                }
                TypeReference referenceType = this.getType(parent);
                if (!operandType.isPrimitive() && referenceType != null && !this.isCastRedundantInReferenceExpression(referenceType, operand)) {
                    return;
                }
            }
            if (this.arrayAccessAtTheLeftSideOfAssignment(parent)) {
                if (MetadataHelper.isAssignableFrom(operandType, castTo, false) && MetadataHelper.getArrayRank(operandType) == MetadataHelper.getArrayRank(castTo)) {
                    this.addToResults(cast, false);
                }
            } else if (MetadataHelper.isAssignableFrom(castTo, operandType, false)) {
                this.addToResults(cast, false);
            }
        }

        protected boolean arrayAccessAtTheLeftSideOfAssignment(AstNode node) {
            AssignmentExpression assignment = CollectionUtilities.firstOrDefault(node.getAncestors(AssignmentExpression.class));
            if (assignment == null) {
                return false;
            }
            Expression left = assignment.getLeft();
            return left.isAncestorOf(node) && left instanceof IndexerExpression;
        }

        protected boolean isCastRedundantInReferenceExpression(TypeReference type, Expression operand) {
            return false;
        }

        protected boolean checkResolveAfterRemoveCast(AstNode parent) {
            List<MethodReference> candidates;
            MethodBinder.BindResult result;
            AstNode grandParent = parent.getParent();
            if (grandParent == null || parent.getRole() != Roles.ARGUMENT) {
                return true;
            }
            TypeReference targetType = grandParent instanceof InvocationExpression ? this.getType(((InvocationExpression)grandParent).getTarget()) : this.getType(grandParent);
            if (targetType == null) {
                return false;
            }
            Expression expression = (Expression)grandParent.clone();
            AstNodeCollection<Expression> arguments = expression.getChildrenByRole(Roles.ARGUMENT);
            List<TypeReference> argumentTypes = this.getTypes(arguments);
            if (argumentTypes.isEmpty()) {
                return arguments.isEmpty();
            }
            MemberReference memberReference = grandParent.getUserData(Keys.MEMBER_REFERENCE);
            if (!(memberReference instanceof MethodReference) && grandParent.getParent() != null) {
                memberReference = grandParent.getParent().getUserData(Keys.MEMBER_REFERENCE);
            }
            if (!(memberReference instanceof MethodReference)) {
                return false;
            }
            MethodReference method = (MethodReference)memberReference;
            MethodDefinition resolvedMethod = method.resolve();
            if (resolvedMethod == null) {
                return false;
            }
            int argumentIndex = CollectionUtilities.indexOf(grandParent.getChildrenByRole(Roles.ARGUMENT), (Expression)parent);
            Expression toReplace = CollectionUtilities.get(arguments, argumentIndex);
            if (toReplace instanceof ConditionalExpression) {
                Expression falseOperand;
                TypeReference operandType;
                Expression trueExpression = ((ConditionalExpression)toReplace).getTrueExpression();
                Expression falseExpression = ((ConditionalExpression)toReplace).getFalseExpression();
                if (trueExpression instanceof CastExpression) {
                    Expression trueOperand = ((CastExpression)trueExpression).getExpression();
                    TypeReference operandType2 = this.getType(trueOperand);
                    if (operandType2 != null) {
                        trueExpression.replaceWith(trueOperand);
                    }
                } else if (falseExpression instanceof CastExpression && (operandType = this.getType(falseOperand = ((CastExpression)falseExpression).getExpression())) != null) {
                    falseExpression.replaceWith(falseOperand);
                }
                TypeReference newArgumentType = this.getType(toReplace);
                if (newArgumentType == null) {
                    return false;
                }
                argumentTypes.set(argumentIndex, newArgumentType);
            }
            return !(result = MethodBinder.selectMethod(candidates = MetadataHelper.findMethods(targetType, MetadataFilters.matchName(resolvedMethod.getName())), argumentTypes)).isFailure() && !result.isAmbiguous() && StringUtilities.equals(resolvedMethod.getErasedSignature(), result.getMethod().getErasedSignature());
        }

        public boolean isTypeCastSemantic(CastExpression cast) {
            TypeReference expectedType;
            Expression operand = cast.getExpression();
            if (operand.isNull()) {
                return false;
            }
            if (this.isInPolymorphicCall(cast)) {
                return true;
            }
            TypeReference opType = this.getType(operand);
            TypeReference castType = this.getType(cast.getType());
            if (opType == null || castType == null) {
                return false;
            }
            if (castType instanceof PrimitiveType) {
                ConversionType conversionType;
                ConversionType conversionType2;
                if (opType instanceof PrimitiveType && (conversionType2 = MetadataHelper.getNumericConversionType(castType, opType)) != ConversionType.IDENTITY && conversionType2 != ConversionType.IMPLICIT) {
                    return true;
                }
                TypeReference unboxedOpType = MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(opType);
                if (unboxedOpType.isPrimitive() && (conversionType = MetadataHelper.getNumericConversionType(castType, unboxedOpType)) != ConversionType.IDENTITY && conversionType != ConversionType.IMPLICIT) {
                    return true;
                }
            } else if (castType instanceof IGenericInstance ? MetadataHelper.isRawType(opType) && !MetadataHelper.isAssignableFrom(castType, opType) : MetadataHelper.isRawType(castType) && opType instanceof IGenericInstance && !MetadataHelper.isAssignableFrom(castType, opType)) {
                return true;
            }
            if (operand instanceof LambdaExpression || operand instanceof MethodGroupExpression) {
                MetadataParser parser = new MetadataParser(IMetadataResolver.EMPTY);
                TypeReference serializable = parser.parseTypeDescriptor("java/lang/Serializable");
                if (!castType.isPrimitive() && MetadataHelper.isSubType(castType, serializable)) {
                    return true;
                }
                if (castType instanceof CompoundTypeReference) {
                    boolean redundant = false;
                    CompoundTypeReference compoundType = (CompoundTypeReference)castType;
                    List<TypeReference> interfaces = compoundType.getInterfaces();
                    int start = 0;
                    TypeReference baseType = compoundType.getBaseType();
                    if (baseType == null) {
                        baseType = CollectionUtilities.first(interfaces);
                        start = 1;
                    }
                    for (int i = start; i < interfaces.size(); ++i) {
                        TypeReference conjunct = interfaces.get(i);
                        if (!MetadataHelper.isAssignableFrom(baseType, conjunct)) continue;
                        redundant = true;
                        break;
                    }
                    if (!redundant) {
                        return true;
                    }
                }
            }
            AstNode parent = cast.getParent();
            while (parent instanceof ParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof BinaryOperatorExpression) {
                BinaryOperatorExpression expression = (BinaryOperatorExpression)parent;
                Expression firstOperand = expression.getLeft();
                Expression otherOperand = expression.getRight();
                if (otherOperand.isAncestorOf(cast)) {
                    Expression temp = otherOperand;
                    otherOperand = firstOperand;
                    firstOperand = temp;
                }
                if (firstOperand != null && otherOperand != null && this.castChangesComparisonSemantics(firstOperand, otherOperand, operand, expression.getOperator())) {
                    return true;
                }
            } else if (parent instanceof ConditionalExpression && opType.isPrimitive() && !(this.getType(parent) instanceof PrimitiveType) && (expectedType = TypeUtilities.getExpectedTypeByParent(this._resolver, (Expression)parent)) != null && MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(expectedType).isPrimitive()) {
                return true;
            }
            return false;
        }

        public boolean isInPolymorphicCall(CastExpression cast) {
            Expression operand = cast.getExpression();
            if ((operand instanceof InvocationExpression || operand instanceof MemberReferenceExpression && operand.getParent() instanceof InvocationExpression || operand instanceof ObjectCreationExpression) && IsRedundantVisitor.isPolymorphicMethod(operand)) {
                return true;
            }
            return cast.getRole() == Roles.ARGUMENT && IsRedundantVisitor.isPolymorphicMethod(RedundantCastUtility.skipParenthesesUp(cast.getParent()));
        }

        private static boolean isPolymorphicMethod(AstNode expression) {
            if (expression == null) {
                return false;
            }
            MemberReference memberReference = expression.getUserData(Keys.MEMBER_REFERENCE);
            if (memberReference == null && expression.getParent() instanceof MemberReferenceExpression) {
                memberReference = expression.getParent().getUserData(Keys.MEMBER_REFERENCE);
            }
            if (memberReference != null) {
                List<CustomAnnotation> annotations = memberReference.getAnnotations();
                for (CustomAnnotation annotation : annotations) {
                    String typeName = annotation.getAnnotationType().getInternalName();
                    if (!StringUtilities.equals(typeName, "java.lang.invoke.MethodHandle.PolymorphicSignature")) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean castChangesComparisonSemantics(Expression operand, Expression otherOperand, Expression toCast, BinaryOperatorType operator) {
            boolean isPrimitiveComparisonWithoutCast;
            boolean isPrimitiveComparisonWithCast;
            TypeReference operandType = this.getType(operand);
            TypeReference otherType = this.getType(otherOperand);
            TypeReference castType = this.getType(toCast);
            if (operator == BinaryOperatorType.EQUALITY || operator == BinaryOperatorType.INEQUALITY) {
                if (TypeUtilities.isPrimitive(otherType)) {
                    isPrimitiveComparisonWithCast = TypeUtilities.isPrimitiveOrWrapper(operandType);
                    isPrimitiveComparisonWithoutCast = TypeUtilities.isPrimitiveOrWrapper(castType);
                } else {
                    isPrimitiveComparisonWithCast = TypeUtilities.isPrimitive(operandType);
                    isPrimitiveComparisonWithoutCast = TypeUtilities.isPrimitive(castType);
                }
            } else {
                isPrimitiveComparisonWithCast = operandType != null && operandType.isPrimitive() || otherType != null && otherType.isPrimitive();
                isPrimitiveComparisonWithoutCast = castType != null && castType.isPrimitive() || operandType != null && operandType.isPrimitive();
            }
            return isPrimitiveComparisonWithCast != isPrimitiveComparisonWithoutCast;
        }
    }

    private static class CastCollector
    extends IsRedundantVisitor {
        private final Set<CastExpression> _foundCasts = new HashSet<CastExpression>();

        CastCollector(Function<AstNode, ResolveResult> resolver) {
            super(resolver, true);
        }

        private Set<CastExpression> getFoundCasts() {
            return this._foundCasts;
        }

        @Override
        public Void visitAnonymousObjectCreationExpression(AnonymousObjectCreationExpression node, Void data) {
            for (Expression argument : node.getArguments()) {
                argument.acceptVisitor(this, data);
            }
            return null;
        }

        @Override
        public Void visitTypeDeclaration(TypeDeclaration typeDeclaration, Void _) {
            return null;
        }

        @Override
        public Void visitLocalTypeDeclarationStatement(LocalTypeDeclarationStatement node, Void data) {
            return null;
        }

        @Override
        public Void visitMethodDeclaration(MethodDeclaration node, Void _) {
            return null;
        }

        @Override
        public Void visitConstructorDeclaration(ConstructorDeclaration node, Void _) {
            return null;
        }

        @Override
        protected void addToResults(@NotNull CastExpression cast, boolean force) {
            if (force || !this.isTypeCastSemantic(cast)) {
                this._foundCasts.add(cast);
            }
        }
    }
}

