/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.IMethodSignature;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.ArrayCreationExpression;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.LambdaExpression;
import com.strobel.decompiler.languages.java.ast.MethodGroupExpression;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.TypeReferenceExpression;
import com.strobel.decompiler.patterns.AnyNode;
import com.strobel.decompiler.patterns.IdentifierExpressionBackReference;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.NamedNode;
import com.strobel.decompiler.patterns.OptionalNode;

public class RewriteNewArrayLambdas
extends ContextTrackingVisitor<Void> {
    protected RewriteNewArrayLambdas(DecompilerContext context) {
        super(context);
    }

    @Override
    public Void visitLambdaExpression(LambdaExpression node, Void data) {
        IMethodSignature signature;
        super.visitLambdaExpression(node, data);
        DynamicCallSite callSite = node.getUserData(Keys.DYNAMIC_CALL_SITE);
        if (callSite != null && callSite.getBootstrapArguments().size() >= 3 && callSite.getBootstrapArguments().get(2) instanceof IMethodSignature && (signature = (IMethodSignature)callSite.getBootstrapArguments().get(2)).getParameters().size() == 1 && signature.getParameters().get(0).getParameterType().getSimpleType() == JvmType.Integer && signature.getReturnType().isArray() && !signature.getReturnType().getElementType().isGenericType()) {
            LambdaExpression pattern = new LambdaExpression(-34);
            ParameterDeclaration size = new ParameterDeclaration();
            size.setName("$any$");
            size.setAnyModifiers(true);
            size.setType(new OptionalNode(new SimpleType("int")).toType());
            pattern.getParameters().add(new NamedNode("size", size).toParameterDeclaration());
            ArrayCreationExpression arrayCreation = new ArrayCreationExpression(-34);
            arrayCreation.getDimensions().add(new IdentifierExpressionBackReference("size").toExpression());
            arrayCreation.setType(new NamedNode("type", new AnyNode()).toType());
            pattern.setBody(arrayCreation);
            Match match = pattern.match(node);
            if (match.success()) {
                AstType type = (AstType)CollectionUtilities.first(match.get("type"));
                if (signature.getReturnType().getElementType().isEquivalentTo(type.toTypeReference())) {
                    MethodGroupExpression replacement = new MethodGroupExpression(-34, new TypeReferenceExpression(-34, type.clone().makeArrayType()), "new");
                    TypeReference lambdaType = node.getUserData(Keys.TYPE_REFERENCE);
                    if (lambdaType != null) {
                        replacement.putUserData(Keys.TYPE_REFERENCE, lambdaType);
                    }
                    replacement.putUserData(Keys.DYNAMIC_CALL_SITE, callSite);
                    node.replaceWith(replacement);
                }
            }
        }
        return null;
    }
}

