/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.tweaker;

import java.util.HashSet;
import java.util.Set;

public enum ClassType {
    Excluded(false, false, false, "java", "javax", "sun", "com.mojang", "org.apache", "com.google", "javassist", "org.reflections", "gnu.trove", "io.netty", "joptsimple", "paulscode.sound", "com.jcraft"),
    Minecraft(true, true, false, "net.minecraft"),
    ModLoader(true, false, true, "cuchaz.m3l"),
    Other(true, false, true, new String[0]);

    private boolean m_shouldTranslate;
    private boolean m_shouldHook;
    private boolean m_shouldFilter;
    private Set<String> m_packages;

    private ClassType(boolean shouldTranslate, boolean shouldHook, boolean shouldFilter, String ... packages) {
        this.m_shouldTranslate = shouldTranslate;
        this.m_shouldHook = shouldHook;
        this.m_shouldFilter = shouldFilter;
        this.m_packages = new HashSet<String>();
        String[] stringArray = packages;
        int n2 = packages.length;
        int n3 = 0;
        while (n3 < n2) {
            String thePackage = stringArray[n3];
            this.m_packages.add(thePackage);
            ++n3;
        }
    }

    public boolean shouldTranslate() {
        return this.m_shouldTranslate;
    }

    public boolean shouldHook() {
        return this.m_shouldHook;
    }

    public boolean shouldFilter() {
        return this.m_shouldFilter;
    }

    public Iterable<String> getPackages() {
        return this.m_packages;
    }

    public boolean includes(String nameJava) {
        String thePackage = nameJava;
        while ((thePackage = ClassType.getPackage(thePackage)) != null) {
            if (!this.m_packages.contains(thePackage)) continue;
            return true;
        }
        return false;
    }

    public static ClassType get(String name) {
        ClassType[] classTypeArray = ClassType.values();
        int n = classTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassType type = classTypeArray[n2];
            if (type.includes(name)) {
                return type;
            }
            ++n2;
        }
        return Other;
    }

    private static String getPackage(String nameJava) {
        int index = nameJava.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return nameJava.substring(0, index);
    }
}

