/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.mod;

import com.google.common.collect.Maps;
import cuchaz.m3l.M3L;
import cuchaz.m3l.discovery.ModDiscoveries;
import cuchaz.m3l.mod.M3LModContainer;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;

public class ModContainers {
    private Map<String, M3LModContainer> m_containersById = Maps.newHashMap();
    private Map<Object, M3LModContainer> m_containersByMod = Maps.newHashMap();
    private Map<String, M3LModContainer> m_containersByModClassName = Maps.newHashMap();

    public void load() {
        this.construct();
        this.sendLifeEventToMods((FMLStateEvent)new FMLConstructionEvent(new Object[]{null, null, null}));
        this.sendLifeEventToMods((FMLStateEvent)new FMLPreInitializationEvent(new Object[]{null, null}));
        this.sendLifeEventToMods((FMLStateEvent)new FMLInitializationEvent(new Object[0]));
        this.sendLifeEventToMods((FMLStateEvent)new FMLPostInitializationEvent(new Object[0]));
        this.sendLifeEventToMods((FMLStateEvent)new FMLLoadCompleteEvent(new Object[0]));
    }

    private void construct() {
        List<String> modClassNames = ModDiscoveries.getClassNames("cuchaz.m3l.discoveredModClassNames");
        if (modClassNames.isEmpty()) {
            M3L.log.info("No mods to load");
            return;
        }
        M3L.log.info("Loading {} mods...", (Object)modClassNames.size());
        for (String modClassName : modClassNames) {
            M3L.log.info("Loading mod: {}", (Object)modClassName);
            try {
                Class<?> modClass = Class.forName(modClassName);
                Mod annotation = modClass.getAnnotation(Mod.class);
                if (annotation == null) {
                    M3L.log.error("Loaded class is not a mod: {}", (Object)modClassName);
                }
                M3LModContainer container = new M3LModContainer(annotation, modClass.newInstance());
                this.m_containersById.put(container.getModId(), container);
                this.m_containersByMod.put(container.getMod(), container);
                this.m_containersByModClassName.put(modClassName, container);
            }
            catch (ClassNotFoundException ex) {
                M3L.log.error("Couldn't find mod class: {}", (Object)modClassName, (Object)ex);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                M3L.log.error("Couldn't get mod instance: {}", (Object)modClassName, (Object)ex);
            }
        }
    }

    public void sendLifeEventToMods(FMLStateEvent event) {
        for (M3LModContainer mod : this.m_containersById.values()) {
            mod.sendEvent(event);
        }
    }

    public M3LModContainer getFromStackTrace() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement frame = stackTraceElementArray[n2];
            M3LModContainer mod = this.m_containersByModClassName.get(frame.getClassName());
            if (mod != null) {
                return mod;
            }
            ++n2;
        }
        return null;
    }

    public int size() {
        return this.m_containersById.size();
    }
}

