/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTranslation;

import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MethodMapping;
import java.lang.reflect.Field;
import java.util.List;
import javassist.bytecode.Descriptor;

public class ExceptionTranslator {
    private Mappings m_mappings;
    private Field m_fieldClassName;
    private Field m_fieldMethodName;
    private Field m_fieldFileName;
    private Field m_fieldLineNumber;

    public ExceptionTranslator(Mappings mappings) {
        this.m_mappings = mappings;
        try {
            this.m_fieldClassName = StackTraceElement.class.getDeclaredField("declaringClass");
            this.m_fieldClassName.setAccessible(true);
            this.m_fieldMethodName = StackTraceElement.class.getDeclaredField("methodName");
            this.m_fieldMethodName.setAccessible(true);
            this.m_fieldFileName = StackTraceElement.class.getDeclaredField("fileName");
            this.m_fieldFileName.setAccessible(true);
            this.m_fieldLineNumber = StackTraceElement.class.getDeclaredField("lineNumber");
            this.m_fieldLineNumber.setAccessible(true);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public void translate(Throwable in) {
        Throwable t = in;
        while (t != null) {
            StackTraceElement[] stackTraceElementArray = t.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement frame = stackTraceElementArray[n2];
                ClassEntry obfClassEntry = new ClassEntry(Descriptor.toJvmName((String)frame.getClassName()));
                if (obfClassEntry.isInDefaultPackage()) {
                    obfClassEntry = new ClassEntry("none/" + obfClassEntry.getName());
                }
                List mappingsChain = this.m_mappings.getClassMappingChain(obfClassEntry);
                String[] obfClassNames = obfClassEntry.getName().split("\\$");
                StringBuilder buf = new StringBuilder();
                int i = 0;
                while (i < obfClassNames.length) {
                    boolean isFirstClass = buf.length() == 0;
                    String className = obfClassNames[i];
                    ClassMapping classMapping = (ClassMapping)mappingsChain.get(i);
                    if (classMapping != null) {
                        className = classMapping.getDeobfName();
                    }
                    if (!isFirstClass) {
                        buf.append("$");
                    }
                    buf.append(className);
                    ++i;
                }
                ClassEntry deobfClassEntry = new ClassEntry(buf.toString());
                this.setClassName(frame, Descriptor.toJavaName((String)deobfClassEntry.getName()));
                this.setFileName(frame, String.valueOf(deobfClassEntry.getSimpleName()) + ".java");
                ClassMapping classMapping = (ClassMapping)mappingsChain.get(mappingsChain.size() - 1);
                if (classMapping != null) {
                    buf = new StringBuilder();
                    for (MethodMapping methodMapping : classMapping.methods()) {
                        if (!methodMapping.getObfName().equals(frame.getMethodName())) continue;
                        if (buf.length() > 0) {
                            buf.append("|");
                        }
                        if (methodMapping.getDeobfName() != null) {
                            buf.append(methodMapping.getDeobfName());
                            continue;
                        }
                        buf.append(methodMapping.getObfName());
                    }
                    if (buf.length() > 0) {
                        this.setMethodName(frame, buf.toString());
                    }
                }
                ++n2;
            }
            t = t.getCause();
        }
    }

    private void setClassName(StackTraceElement frame, String val) {
        try {
            this.m_fieldClassName.set(frame, val);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    private void setMethodName(StackTraceElement frame, String val) {
        try {
            this.m_fieldMethodName.set(frame, val);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    private void setFileName(StackTraceElement frame, String val) {
        try {
            this.m_fieldFileName.set(frame, val);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    private void setLineNumber(StackTraceElement frame, int val) {
        try {
            this.m_fieldLineNumber.set(frame, val);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

