/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation.transformers;

import cuchaz.m3l.M3L;
import cuchaz.m3l.Side;
import cuchaz.m3l.api.chunks.ChunkSystem;
import cuchaz.m3l.classTransformation.ClassTransformer;
import cuchaz.m3l.classTransformation.HookCompiler;
import cuchaz.m3l.classTransformation.transformers.BuildSizeTransformer;
import cuchaz.m3l.util.EntryFactory;
import cuchaz.m3l.util.Util;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class WorldTransformer
implements ClassTransformer {
    @Override
    public boolean meetsRequirements(CtClass c) {
        return c.getName().equals(World.class.getName());
    }

    @Override
    public void compile(HookCompiler compiler, CtClass c, Side side) throws NotFoundException, CannotCompileException {
        String me = this.getClass().getName();
        String blockPosType = Util.getClassDesc(BlockPos.class);
        String entityType = Util.getClassDesc(Entity.class);
        String lightTypeType = Util.getClassDesc(LightType.class);
        compiler.insertBeforeBehavior((CtBehavior)c.getDeclaredMethod("getSeaLevel"), "Integer override = " + me + ".getSeaLevel(this);" + "if (override != null) { return override.intValue(); };");
        if (side == Side.Client) {
            compiler.insertBeforeBehavior((CtBehavior)c.getDeclaredMethod("getHorizonLevel"), "Double override = " + me + ".getHorizonLevel(this);" + "if (override != null) { return override.doubleValue(); };");
        }
        compiler.insertBeforeBehavior((CtBehavior)c.getMethod("updateLightingAt", "(" + lightTypeType + blockPosType + ")Z"), "Boolean override = " + me + ".updateLightingAt(this, $$);" + "if (override != null) { return override.booleanValue(); }");
        compiler.insertBeforeBehavior((CtBehavior)c.getMethod("checkBlockRangeIsInWorld", "(IIIIIIZ)Z"), "Boolean override = " + me + ".checkBlockRangeIsInWorld(this, $$);" + "if (override != null) { return override.booleanValue(); }");
        compiler.replaceVirtualCall((CtBehavior)c.getMethod("updateEntity", "(" + entityType + "Z)V"), EntryFactory.getBehaviorEntry(World.class, "checkBlockRangeIsInWorld", "(IIIIIIZ)Z", new Class[0]), EntryFactory.getClassEntry(WorldTransformer.class), "checkChunksExistForEntityUpdate", true);
        compiler.insertBeforeBehavior((CtBehavior)c.getMethod("getHeight", "()I"), "return " + BuildSizeTransformer.class.getName() + ".getBuildHeight(this);");
        compiler.insertBeforeBehavior((CtBehavior)c.getMethod("getActualHeight", "()I"), "return " + BuildSizeTransformer.class.getName() + ".getBuildHeight(this);");
        String args = "this";
        CtMethod method = c.getMethod("isBlockInWorld", "(" + blockPosType + ")Z");
        BuildSizeTransformer.setBuildHeight(compiler, (CtBehavior)method, args);
        BuildSizeTransformer.setBuildDepthLt(compiler, method, args);
        method = c.getMethod("getLight", "(" + blockPosType + ")I");
        BuildSizeTransformer.setBuildHeight(compiler, (CtBehavior)method, args);
        BuildSizeTransformer.setBuildDepthGt(compiler, method, args);
        method = c.getMethod("getLightAt", "(" + lightTypeType + blockPosType + ")I");
        BuildSizeTransformer.setBuildDepthGt(compiler, method, args);
        method = c.getMethod("getNeighborLight", "(" + blockPosType + "Z)I");
        BuildSizeTransformer.setBuildHeight(compiler, (CtBehavior)method, args);
        BuildSizeTransformer.setMaxBlockY(compiler, (CtBehavior)method, args);
        BuildSizeTransformer.setBuildDepthGt(compiler, method, args);
        method = c.getMethod("canBlockFreeze", "(" + blockPosType + "Z)Z");
        BuildSizeTransformer.setBuildHeight(compiler, (CtBehavior)method, args);
        BuildSizeTransformer.setBuildDepthLt(compiler, method, args);
        method = c.getMethod("canSnowAt", "(" + blockPosType + "Z)Z");
        BuildSizeTransformer.setBuildHeight(compiler, (CtBehavior)method, args);
        BuildSizeTransformer.setBuildDepthLt(compiler, method, args);
    }

    public static Integer getSeaLevel(World world) {
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null) {
            return chunkSystem.getSeaLevel(world);
        }
        return null;
    }

    public static Double getHorizonLevel(World world) {
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null) {
            return chunkSystem.getHorizonLevel(world);
        }
        return null;
    }

    public static Boolean updateLightingAt(World world, LightType type, BlockPos pos) {
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null) {
            return chunkSystem.updateLightingAt(world, type, pos);
        }
        return null;
    }

    public static Boolean checkBlockRangeIsInWorld(World world, int minBlockX, int minBlockY, int minBlockZ, int maxBlockX, int maxBlockY, int maxBlockZ, boolean allowEmptyChunks) {
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null) {
            return chunkSystem.checkBlockRangeIsInWorld(world, minBlockX, minBlockY, minBlockZ, maxBlockX, maxBlockY, maxBlockZ, allowEmptyChunks);
        }
        return null;
    }

    public static boolean checkChunksExistForEntityUpdate(World world, int minBlockX, int minBlockY, int minBlockZ, int maxBlockX, int maxBlockY, int maxBlockZ, boolean allowEmptyChunks, World worldAgain, Entity entity, boolean forceUpdate) {
        Boolean result;
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null && (result = chunkSystem.checkEntityIsInWorld(world, entity, minBlockX, minBlockZ, maxBlockX, maxBlockZ, allowEmptyChunks)) != null) {
            return result;
        }
        return world.checkBlockRangeIsInWorld(minBlockX, minBlockY, minBlockZ, maxBlockX, maxBlockY, maxBlockZ, allowEmptyChunks);
    }
}

