/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation.transformers;

import cuchaz.m3l.M3L;
import cuchaz.m3l.Side;
import cuchaz.m3l.api.chunks.ChunkSystem;
import cuchaz.m3l.classTransformation.ClassTransformer;
import cuchaz.m3l.classTransformation.HookCompiler;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.gen.ServerChunkCache;

public class WorldServerTransformer
implements ClassTransformer {
    @Override
    public boolean meetsRequirements(CtClass c) {
        return c.getName().equals(WorldServer.class.getName());
    }

    @Override
    public void compile(HookCompiler compiler, CtClass c, Side side) throws NotFoundException, CannotCompileException {
        compiler.insertBeforeBehavior((CtBehavior)c.getDeclaredMethod("createChunkCache"), String.valueOf(ServerChunkCache.class.getName()) + " override = " + this.getClass().getName() + ".getChunkCache(this);" + "if (override != null) { this.serverChunkCache = override; return override; }");
        CtConstructor[] ctConstructorArray = c.getDeclaredConstructors();
        int n = ctConstructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtConstructor constructor = ctConstructorArray[n2];
            compiler.insertAfterVoidBehavior((CtBehavior)constructor, String.valueOf(PlayerManager.class.getName()) + " override = " + this.getClass().getName() + ".getPlayerManager(this);" + "if (override != null) { this.playerManager = override; }");
            ++n2;
        }
        compiler.insertAfterVoidBehavior((CtBehavior)c.getDeclaredMethod("tick"), String.valueOf(this.getClass().getName()) + ".onWorldServerTick(this);");
        compiler.insertBeforeBehavior((CtBehavior)c.getDeclaredMethod("initializeSpawn"), "boolean calculated = " + this.getClass().getName() + ".calculateSpawn(this, $1);" + "if (calculated) { return; }");
    }

    public static ServerChunkCache getChunkCache(WorldServer worldServer) {
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null) {
            return chunkSystem.getServerChunkCache(worldServer);
        }
        return null;
    }

    public static PlayerManager getPlayerManager(WorldServer worldServer) {
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null) {
            return chunkSystem.getPlayerManager(worldServer);
        }
        return null;
    }

    public static void onWorldServerTick(WorldServer worldServer) {
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null) {
            chunkSystem.onWorldServerTick(worldServer);
        }
    }

    public static boolean calculateSpawn(WorldServer worldServer, WorldSettings settings) {
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null) {
            return chunkSystem.calculateSpawn(worldServer, settings);
        }
        return false;
    }
}

