/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation.transformers;

import cuchaz.m3l.M3L;
import cuchaz.m3l.Side;
import cuchaz.m3l.api.chunks.ChunkSystem;
import cuchaz.m3l.classTransformation.ClassTransformer;
import cuchaz.m3l.classTransformation.HookCompiler;
import cuchaz.m3l.util.EntryFactory;
import cuchaz.m3l.util.Util;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;
import net.minecraft.client.renderers.ChunkSectionRenderer;
import net.minecraft.client.renderers.WorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySet;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Facing;
import net.minecraft.world.chunk.Chunk;

public class WorldRendererTransformer
implements ClassTransformer {
    @Override
    public boolean meetsRequirements(CtClass c) {
        return c.getName().equals(WorldRenderer.class.getName());
    }

    @Override
    public void compile(HookCompiler compiler, CtClass c, Side side) throws NotFoundException, CannotCompileException {
        compiler.insertBeforeBehavior((CtBehavior)c.getDeclaredMethod("getChunkSectionRendererNeighbor"), String.valueOf(ChunkSectionRenderer.class.getName()) + " override = " + this.getClass().getName() + ".getChunkSectionRendererNeighbor(this, $$);" + "if (override != null) { return override; }");
        compiler.replaceVirtualCallThenArrayAccess((CtBehavior)c.getDeclaredMethod("renderEntities"), EntryFactory.getBehaviorEntry(Chunk.class, "getEntityStore", "()[" + Util.getClassDesc(EntitySet.class), new Class[0]), EntryFactory.getClassEntry(this.getClass()), "getEntityStore");
    }

    public static ChunkSectionRenderer getChunkSectionRendererNeighbor(WorldRenderer worldRenderer, BlockPos pos, ChunkSectionRenderer chunkSectionRenderer, Facing facing) {
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null) {
            return chunkSystem.getChunkSectionRendererNeighbor(worldRenderer, pos, chunkSectionRenderer, facing);
        }
        return null;
    }

    public static EntitySet<Entity> getEntityStore(Chunk chunk, int chunkSectionIndex) {
        EntitySet<Entity> override;
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null && (override = chunkSystem.getEntityStore(chunk, chunkSectionIndex)) != null) {
            return override;
        }
        return chunk.getEntityStore()[chunkSectionIndex];
    }
}

