/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation.transformers;

import cuchaz.m3l.M3L;
import cuchaz.m3l.Side;
import cuchaz.m3l.api.chunks.ChunkSystem;
import cuchaz.m3l.classTransformation.ClassTransformer;
import cuchaz.m3l.classTransformation.HookCompiler;
import cuchaz.m3l.util.EntryFactory;
import java.util.Random;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;
import net.minecraft.world.MobSpawner;
import net.minecraft.world.World;

public class MobSpawnerTransformer
implements ClassTransformer {
    @Override
    public boolean meetsRequirements(CtClass c) {
        return c.getName().equals(MobSpawner.class.getName());
    }

    @Override
    public void compile(HookCompiler compiler, CtClass c, Side side) throws NotFoundException, CannotCompileException {
        compiler.replaceVirtualCall((CtBehavior)c.getDeclaredMethod("getRandomBlockPosAboveSurface"), EntryFactory.getBehaviorEntry(Random.class, "nextInt", "(I)I", new Class[0]), EntryFactory.getClassEntry(this.getClass()), "getSpawnY", true);
    }

    public static int getSpawnY(Random rand, int upper, World world, int cubeX, int cubeZ) {
        Integer blockY;
        ChunkSystem chunkSystem;
        if (upper != 16 && (chunkSystem = M3L.instance.getRegistry().chunkSystem.get()) != null && (blockY = chunkSystem.getRandomBlockYForMobSpawnAttempt(rand, upper, world, cubeX, cubeZ)) != null) {
            return blockY;
        }
        return rand.nextInt(upper);
    }
}

