/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation.transformers;

import cuchaz.m3l.M3L;
import cuchaz.m3l.Side;
import cuchaz.m3l.api.chunks.ChunkSystem;
import cuchaz.m3l.classTransformation.ClassTransformer;
import cuchaz.m3l.classTransformation.HookCompiler;
import cuchaz.m3l.util.Util;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;

public class MinecraftServerTransformer
implements ClassTransformer {
    @Override
    public boolean meetsRequirements(CtClass c) {
        return c.getName().equals(MinecraftServer.class.getName());
    }

    @Override
    public void compile(HookCompiler compiler, CtClass c, Side side) throws NotFoundException, CannotCompileException {
        switch (side) {
            case Client: {
                compiler.insertAfterVoidBehavior((CtBehavior)c.getMethod("initialLevelChunkLoad", "()V"), String.valueOf(this.getClass().getName()) + ".generateWorlds(this);");
                compiler.insertAfterVoidBehavior((CtBehavior)c.getDeclaredMethod("stopServer"), String.valueOf(this.getClass().getName()) + ".stopServer();");
                break;
            }
            case Server: {
                compiler.insertBeforeBehavior((CtBehavior)c.getMethod("main", "(" + Util.getClassDesc(String[].class) + ")V"), String.valueOf(this.getClass().getName()) + ".onMain();");
            }
        }
    }

    public static void onMain() {
        M3L.instance.initDedicatedServer();
    }

    public static void generateWorlds(MinecraftServer server) {
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null) {
            WorldServer[] worldServerArray = server.worlds;
            int n = server.worlds.length;
            int n2 = 0;
            while (n2 < n) {
                WorldServer worldServer = worldServerArray[n2];
                chunkSystem.generateWorld(worldServer);
                ++n2;
            }
        }
    }

    public static void stopServer() {
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null) {
            chunkSystem.onServerStop();
        }
    }
}

