/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation.transformers;

import cuchaz.m3l.Side;
import cuchaz.m3l.classTransformation.ClassTransformer;
import cuchaz.m3l.classTransformation.HookCompiler;
import cuchaz.m3l.util.NumberUtils;
import cuchaz.m3l.util.Util;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.RegistryNamespaced;

public class ItemTransformer
implements ClassTransformer {
    @Override
    public boolean meetsRequirements(CtClass c) {
        return c.getName().equals(Item.class.getName());
    }

    @Override
    public void compile(HookCompiler compiler, CtClass c, Side side) throws NotFoundException, CannotCompileException {
        CtMethod method = c.getMethod("registerItems", "()V");
        method.instrument(new ExprEditor(){

            public void edit(MethodCall call) throws CannotCompileException {
                if (call.getClassName().equals(RegistryNamespaced.class.getName()) && call.getMethodName().equals("addObject")) {
                    call.replace("if( " + NumberUtils.class.getName() + ".isVanillaBlock( $1 ) || !( " + ItemBlock.class.getName() + ".class.isAssignableFrom( $3.getClass() ) ) ) { $proceed( $$ ); }");
                }
            }
        });
        method.insertAfter(String.valueOf(this.getClass().getName()) + ".onAfterItemsRegistered();");
        compiler.replaceBehavior((CtBehavior)method);
        method = c.getMethod("getItemFromBlock", "(" + Util.getClassDesc(Block.class) + ")" + Util.getClassDesc(Item.class));
        method.setBody("return " + ItemTransformer.class.getName() + ".onGetItemFromBlock( $1 );");
        compiler.replaceBehavior((CtBehavior)method);
    }

    public static void onAfterItemsRegistered() {
    }

    public static Item onGetItemFromBlock(Block block) {
        int blockNumber = Block.getBlockIndex((Block)block);
        if (NumberUtils.isModBlock(blockNumber)) {
            return Item.getItem((int)NumberUtils.getModItemNumberFromModBlockNumber(blockNumber));
        }
        return Item.getItem((int)blockNumber);
    }
}

