/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation.transformers;

import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.m3l.M3L;
import cuchaz.m3l.api.chunks.ChunkSystem;
import cuchaz.m3l.classTransformation.HookCompiler;
import cuchaz.m3l.util.EntryFactory;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtMethod;
import javassist.NotFoundException;
import net.minecraft.world.World;

public class BuildSizeTransformer {
    public static ClassEntry m_thisClass = EntryFactory.getClassEntry(BuildSizeTransformer.class);

    public static void setBuildHeight(HookCompiler compiler, CtBehavior behavior, String args) throws NotFoundException, CannotCompileException {
        compiler.replaceInt(behavior, 256, m_thisClass, "getBuildHeight", args);
    }

    public static void setMaxBlockY(HookCompiler compiler, CtBehavior behavior, String args) throws NotFoundException, CannotCompileException {
        compiler.replaceInt(behavior, 255, m_thisClass, "getMaxBlockY", args);
    }

    public static void setBuildDepthGt(HookCompiler compiler, CtMethod method, String args) throws NotFoundException, CannotCompileException {
        compiler.replaceGtZero((CtBehavior)method, m_thisClass, "getBuildDepth", args);
    }

    public static void setBuildDepthLt(HookCompiler compiler, CtMethod method, String args) throws NotFoundException, CannotCompileException {
        compiler.replaceLtZero((CtBehavior)method, m_thisClass, "getBuildDepth", args);
    }

    public static int getMaxBlockY(World world) {
        Integer result;
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null && (result = chunkSystem.getMaxBlockY(world)) != null) {
            return result;
        }
        return 255;
    }

    public static int getBuildHeight(World world) {
        return BuildSizeTransformer.getMaxBlockY(world) + 1;
    }

    public static int getBuildDepth(World world) {
        Integer result;
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null && (result = chunkSystem.getMinBlockY(world)) != null) {
            return result;
        }
        return 0;
    }
}

