/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation.transformers;

import cuchaz.m3l.Side;
import cuchaz.m3l.classTransformation.ClassTransformer;
import cuchaz.m3l.classTransformation.HookCompiler;
import cuchaz.m3l.util.NumberUtils;
import cuchaz.m3l.util.Util;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class BlockTransformer
implements ClassTransformer {
    @Override
    public boolean meetsRequirements(CtClass c) {
        return c.getName().equals(Block.class.getName());
    }

    @Override
    public void compile(HookCompiler compiler, CtClass c, Side side) throws NotFoundException, CannotCompileException {
        compiler.insertAfterVoidBehavior((CtBehavior)c.getMethod("registerBlocks", "()V"), String.valueOf(this.getClass().getName()) + ".afterBlocksRegistered();");
        CtMethod method = c.getMethod("getBlockFromItem", "(" + Util.getClassDesc(Item.class) + ")" + Util.getClassDesc(Block.class));
        method.setBody("return " + BlockTransformer.class.getName() + ".onGetIdFromItem( $1 );");
        compiler.replaceBehavior((CtBehavior)method);
    }

    public static void afterBlocksRegistered() {
    }

    public static Block onGetIdFromItem(Item item) {
        int itemNumber = Item.getItemId((Item)item);
        if (NumberUtils.isModItemBlock(itemNumber)) {
            return Block.getBlockFromIndex((int)NumberUtils.getModBlockNumberFromModItemNumber(itemNumber));
        }
        return Block.getBlockFromIndex((int)itemNumber);
    }
}

