/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation.hooks;

import cuchaz.enigma.bytecode.ConstPoolEditor;
import cuchaz.enigma.bytecode.InfoType;
import cuchaz.m3l.classTransformation.hooks.BehaviorHook;
import cuchaz.m3l.util.BytecodeTools;
import javassist.CtBehavior;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;

public class DoubleReplacementHook
extends BehaviorHook {
    private static final long serialVersionUID = -1079931895658437052L;
    private double m_val;

    public DoubleReplacementHook(CtBehavior behavior, double val, byte[] bytecode) {
        super(behavior, bytecode);
        this.m_val = val;
    }

    @Override
    protected void onApply(CtBehavior behavior, Bytecode bytecode) throws BadBytecode {
        bytecode = BytecodeTools.prepareMethodForBytecode(behavior, bytecode);
        ConstPool constPool = behavior.getDeclaringClass().getClassFile().getConstPool();
        ConstPoolEditor editor = new ConstPoolEditor(constPool);
        CodeIterator iterator = behavior.getMethodInfo().getCodeAttribute().iterator();
        block3: while (iterator.hasNext()) {
            int index = iterator.next();
            int opcode = iterator.byteAt(index);
            double oldVal = 0.0;
            switch (opcode) {
                case 20: {
                    int constIndex = iterator.byteAt(index + 1) << 8 | iterator.byteAt(index + 2);
                    if (editor.getItem(constIndex).getType() != InfoType.DoubleInfo || (oldVal = constPool.getDoubleInfo(constIndex)) != this.m_val) continue block3;
                    int spaceNeeded = bytecode.getSize() - 3;
                    if (spaceNeeded > 0) {
                        iterator.insertGap(spaceNeeded);
                    }
                    iterator.write(bytecode.get(), index);
                    behavior.getMethodInfo().getCodeAttribute().computeMaxStack();
                }
            }
        }
    }
}

