/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation;

import com.google.common.collect.Sets;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.m3l.classTransformation.HookLibrary;
import cuchaz.m3l.classTransformation.hooks.BehaviorHook;
import cuchaz.m3l.classTransformation.hooks.ClassHook;
import cuchaz.m3l.util.Logging;
import java.util.Set;
import javassist.CtBehavior;
import javassist.CtClass;
import org.slf4j.Logger;

public class HookInjector {
    private static final Logger log = Logging.getLogger();
    private HookLibrary m_library;
    private Set<ClassEntry> m_hookedClassEntries;

    public HookInjector(HookLibrary library) {
        this.m_library = library;
        this.m_hookedClassEntries = Sets.newHashSet();
        for (ClassHook classHook : this.m_library.classHooks()) {
            this.m_hookedClassEntries.add(classHook.getClassEntry());
        }
        for (BehaviorHook behaviorHook : this.m_library.methodHooks()) {
            this.m_hookedClassEntries.add(behaviorHook.getBehaviorEntry().getClassEntry());
        }
    }

    public boolean isClassHooked(ClassEntry deobfClassEntry) {
        return this.m_hookedClassEntries.contains(deobfClassEntry);
    }

    public void transformClass(CtClass c) {
        for (ClassHook hook : this.m_library.getHooks(c)) {
            try {
                hook.applyToClass(c);
            }
            catch (Exception ex) {
                log.error(String.format("Cannot transform %s", c.getName()), (Throwable)ex);
            }
        }
        CtBehavior[] ctBehaviorArray = c.getDeclaredBehaviors();
        int n = ctBehaviorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtBehavior behavior = ctBehaviorArray[n2];
            for (BehaviorHook hook : this.m_library.getHooks(behavior)) {
                try {
                    hook.apply(behavior);
                }
                catch (Exception ex) {
                    log.error(String.format("Cannot transform %s.%s()", c.getName(), behavior.getName()), (Throwable)ex);
                }
            }
            ++n2;
        }
    }
}

