/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.MethodInfo;

public class DuckTyper {
    public void removeCheckCasts(CtClass c) {
        CtBehavior[] ctBehaviorArray = c.getDeclaredBehaviors();
        int n = ctBehaviorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtBehavior behavior = ctBehaviorArray[n2];
            try {
                MethodInfo info;
                CodeAttribute attribute;
                if (behavior.getAnnotation(RemoveCheckCasts.class) != null && (attribute = (info = behavior.getMethodInfo()).getCodeAttribute()) != null) {
                    this.removeCheckCasts(attribute);
                }
            }
            catch (ClassNotFoundException ex) {
                throw new Error(ex);
            }
            ++n2;
        }
    }

    private void removeCheckCasts(CodeAttribute attribute) {
        CodeIterator iter = attribute.iterator();
        try {
            while (iter.hasNext()) {
                int pos = iter.next();
                int op = iter.byteAt(pos);
                if (op != 192) continue;
                iter.writeByte(0, pos + 0);
                iter.writeByte(0, pos + 1);
                iter.writeByte(0, pos + 2);
            }
        }
        catch (BadBytecode ex) {
            throw new Error("Can't filter out checkcasts", ex);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface RemoveCheckCasts {
    }
}

