/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation;

import cuchaz.m3l.Side;
import cuchaz.m3l.api.CodeAnnotation;
import cuchaz.m3l.classTranslation.ClientOnly;
import cuchaz.m3l.util.Logging;
import java.util.ArrayList;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.MethodInfo;
import javassist.expr.MethodCall;
import org.slf4j.Logger;

public class ClassFilter {
    private static final Logger log = Logging.getLogger();
    private Side m_side;

    public ClassFilter(Side side) {
        this.m_side = side;
    }

    public void filter(CtClass c) {
        if (this.m_side != Side.Server) {
            return;
        }
        CtBehavior[] ctBehaviorArray = c.getDeclaredBehaviors();
        int n = ctBehaviorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtBehavior behavior = ctBehaviorArray[n2];
            try {
                if (behavior.getAnnotation(ClientOnly.class) != null) {
                    if (behavior instanceof CtMethod) {
                        c.removeMethod((CtMethod)behavior);
                    } else if (behavior instanceof CtConstructor) {
                        c.removeConstructor((CtConstructor)behavior);
                    }
                } else {
                    MethodInfo info = behavior.getMethodInfo();
                    CodeAttribute attribute = info.getCodeAttribute();
                    if (attribute != null) {
                        this.removeAnnotatedBlocks(attribute.iterator(), c, info);
                    }
                }
            }
            catch (ClassNotFoundException ex) {
                log.error("Unable to remove behavior " + behavior.getName(), (Throwable)ex);
            }
            catch (NotFoundException ex) {
                log.error("Unable to remove behavior " + behavior.getName(), (Throwable)ex);
            }
            ++n2;
        }
        ctBehaviorArray = c.getDeclaredFields();
        n = ctBehaviorArray.length;
        n2 = 0;
        while (n2 < n) {
            CtBehavior field = ctBehaviorArray[n2];
            try {
                if (field.getAnnotation(ClientOnly.class) != null) {
                    c.removeField((CtField)field);
                }
            }
            catch (ClassNotFoundException ex) {
                log.error("Unable to remove field " + field.getName(), (Throwable)ex);
            }
            catch (NotFoundException ex) {
                log.error("Unable to remove field " + field.getName(), (Throwable)ex);
            }
            ++n2;
        }
    }

    private void removeAnnotatedBlocks(CodeIterator iter, CtClass c, MethodInfo info) {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        Integer startIndex = null;
        while (iter.hasNext()) {
            try {
                int index = iter.next();
                int op = iter.byteAt(index);
                if (op != 184) continue;
                MethodCallWrapper call = new MethodCallWrapper(index, iter, c, info);
                if (call.getClassName().equals(CodeAnnotation.class.getName()) && call.getMethodName().equals("startClientOnly")) {
                    if (startIndex != null) {
                        throw new IllegalArgumentException("Encountered start block annotation, but another block was already open! " + c.getName() + "." + info.getName() + "()");
                    }
                    startIndex = index;
                    continue;
                }
                if (!call.getClassName().equals(CodeAnnotation.class.getName()) || !call.getMethodName().equals("stopClientOnly")) continue;
                if (startIndex == null) {
                    throw new IllegalArgumentException("Encountered stop block annotation, but no block was open! " + c.getName() + "." + info.getName() + "()");
                }
                int stopIndex = index + 2;
                ranges.add(new CodeRange(startIndex, stopIndex));
                startIndex = null;
            }
            catch (BadBytecode ex) {
                throw new Error(ex);
            }
        }
        if (startIndex != null) {
            throw new IllegalArgumentException("Encountered start block annotation, but did not find close block annotation! " + c.getName() + "." + info.getName() + "()");
        }
        for (CodeRange range : ranges) {
            range.remove(iter);
        }
    }

    private static class CodeRange {
        private int m_startIndex;
        private int m_stopIndex;

        public CodeRange(int startIndex, int stopIndex) {
            this.m_startIndex = startIndex;
            this.m_stopIndex = stopIndex;
        }

        public void remove(CodeIterator iter) {
            int i = this.m_startIndex;
            while (i <= this.m_stopIndex) {
                iter.writeByte(0, i);
                ++i;
            }
        }
    }

    private static class MethodCallWrapper
    extends MethodCall {
        protected MethodCallWrapper(int index, CodeIterator iter, CtClass c, MethodInfo info) {
            super(index, iter, c, info);
        }
    }
}

