/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.api;

public class Version
implements Comparable<Version> {
    private Integer m_major;
    private Integer m_minor;
    private Integer m_build;
    private String m_tag;

    public Version(Integer major, Integer minor, Integer build, String tag) {
        this.m_major = major;
        this.m_minor = minor;
        this.m_build = build;
        this.m_tag = tag;
    }

    public Version(String text) {
        this(null, null, null, null);
        String[] parts;
        String[] versionAndTag = text.split(" ");
        String version = versionAndTag[0];
        if (versionAndTag.length > 1) {
            this.m_tag = versionAndTag[1];
        }
        if ((parts = version.split("\\.")).length >= 1) {
            try {
                this.m_major = Integer.parseInt(parts[0]);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Unable to read major version number from: " + text);
            }
        } else {
            throw new IllegalArgumentException("Could not find major version number from: " + text);
        }
        if (parts.length >= 2) {
            try {
                this.m_minor = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Unable to read minor version number from: " + text);
            }
        }
        if (parts.length >= 3) {
            try {
                this.m_minor = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Unable to read build number number from: " + text);
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.m_major);
        if (this.m_minor != null) {
            buf.append(".");
            buf.append(this.m_minor);
        }
        if (this.m_build != null) {
            buf.append(".");
            buf.append(this.m_minor);
        }
        if (this.m_tag != null) {
            buf.append(" ");
            buf.append(this.m_tag);
        }
        return buf.toString();
    }

    @Override
    public int compareTo(Version other) {
        int compare = this.m_major - other.m_major;
        if (compare != 0) {
            return compare;
        }
        compare = (this.m_minor != null ? this.m_minor : 0) - (other.m_minor != null ? other.m_minor : 0);
        if (compare != 0) {
            return compare;
        }
        compare = (this.m_build != null ? this.m_build : 0) - (other.m_build != null ? other.m_build : 0);
        return compare;
    }

    public boolean equals(Object other) {
        if (other instanceof Version) {
            return this.equals((Version)other);
        }
        return false;
    }

    public boolean equals(Version other) {
        boolean isBuildSame;
        boolean isMajorSame = this.m_major == other.m_major;
        boolean isMinorSame = this.m_minor == null && other.m_minor == null || this.m_minor == other.m_minor;
        boolean bl = isBuildSame = this.m_build == null && other.m_build == null || this.m_build == other.m_build;
        return isMajorSame && isMinorSame && isBuildSame;
    }
}

