/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.api;

import cuchaz.m3l.Side;
import java.util.Arrays;
import java.util.List;

public class Environment {
    private static Boolean m_isObfuscated = null;

    public static boolean isObfuscated() {
        if (m_isObfuscated == null) {
            try {
                Class.forName("net.minecraft.entity.Entity");
                m_isObfuscated = false;
            }
            catch (ClassNotFoundException ex) {
                m_isObfuscated = true;
            }
        }
        return m_isObfuscated;
    }

    public static String getRuntimeName(String name, String id) {
        return Environment.isObfuscated() ? id : name;
    }

    public static Side getSide() {
        if (Environment.isServer()) {
            return Side.Server;
        }
        return Side.Client;
    }

    public static boolean isServer() {
        List<String> serverThreadNames = Arrays.asList("server thread");
        return serverThreadNames.contains(Thread.currentThread().getName().toLowerCase());
    }

    public static boolean isClient() {
        return !Environment.isServer();
    }
}

