/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l;

import cuchaz.enigma.analysis.JarClassIterator;
import cuchaz.enigma.analysis.TranslationIndex;
import cuchaz.enigma.bytecode.ClassRenamer;
import cuchaz.m3l.Constants;
import cuchaz.m3l.Side;
import cuchaz.m3l.util.Logging;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.jar.JarFile;
import javassist.CtClass;
import org.slf4j.Logger;

public class MainTranslationIndex {
    private static final Logger log = Logging.getLogger();

    public static void main(String[] args) throws Exception {
        try {
            if (args.length < 1) {
                throw new IllegalArgumentException("side is a required argument");
            }
            Side side = Side.get(args[0]);
            if (args.length < 2) {
                throw new IllegalArgumentException("pathToObfMinecraftJar is a required argument");
            }
            File jarObfMinecraft = new File(args[1]).getAbsoluteFile();
            if (!jarObfMinecraft.exists()) {
                throw new IllegalArgumentException("File not found: " + jarObfMinecraft.getPath());
            }
            if (args.length < 3) {
                throw new IllegalArgumentException("pathToDeobfMinecraftJar is a required argument");
            }
            File jarDeobfMinecraft = new File(args[2]).getAbsoluteFile();
            if (!jarDeobfMinecraft.exists()) {
                throw new IllegalArgumentException("File not found: " + jarDeobfMinecraft.getPath());
            }
            try {
                MainTranslationIndex.build(Constants.getConfFile(Constants.getResourceObfIndex(side)), new JarFile(jarObfMinecraft));
                MainTranslationIndex.build(Constants.getConfFile(Constants.getResourceDeobfIndex(side)), new JarFile(jarDeobfMinecraft));
            }
            catch (Throwable t) {
                t.printStackTrace(System.out);
            }
        }
        catch (IllegalArgumentException ex) {
            MainTranslationIndex.printHelp();
        }
    }

    private static void printHelp() {
        System.out.println("Magic Mojo Mod Loader (M3L) - v1.8.3-0.4b");
        System.out.println("Translation indexer arguments:");
        System.out.println("\tside pathToObfMinecraftJar pathToDeobfMinecraftJar");
        System.out.println("where side is \"client\" or \"server\"");
        System.out.println("pathToObfMinecraftJar is the path the obfuscated Minecraft jar");
        System.out.println("and pathToDeobfMinecraftJar is the path the deobfuscated Minecraft jar");
    }

    private static void build(File fileOut, JarFile jar) throws Exception {
        TranslationIndex index = new TranslationIndex();
        for (CtClass c : JarClassIterator.classes((JarFile)jar)) {
            ClassRenamer.moveAllClassesOutOfDefaultPackage((CtClass)c, (String)"none");
            index.indexClass(c);
        }
        Throwable throwable = null;
        Iterator iterator = null;
        try (FileOutputStream out = new FileOutputStream(fileOut);){
            index.write((OutputStream)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        log.info("Wrote translation index to:\n\t" + fileOut.getAbsolutePath());
    }
}

