/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l;

import cuchaz.enigma.analysis.TranslationIndex;
import cuchaz.enigma.mapping.MappingParseException;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MappingsReader;
import cuchaz.m3l.Side;
import cuchaz.m3l.classTransformation.HookLibrary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public class Constants {
    public static final String Name = "M3L";
    public static final String Version = "1.8.3-0.4b";
    public static final int KiB = 1024;
    public static final int MiB = 0x100000;
    public static final String MinecraftVersion = "1.8.3";
    public static final File DirConf = new File("conf");

    public static URL getResource(String path) {
        return Constants.class.getResource(path);
    }

    public static String getResourceMappings(Side side) {
        return String.format("/%s.%s.mappings", MinecraftVersion, side.name().toLowerCase());
    }

    public static String getResourceHooks(Side side) {
        return String.format("/%s.%s.hooks", MinecraftVersion, side.name().toLowerCase());
    }

    public static String getResourceObfIndex(Side side) {
        return String.format("/%s.%s.obf.index", MinecraftVersion, side.name().toLowerCase());
    }

    public static String getResourceDeobfIndex(Side side) {
        return String.format("/%s.%s.deobf.index", MinecraftVersion, side.name().toLowerCase());
    }

    public static File getConfFile(String resourcePath) {
        return new File(DirConf, resourcePath);
    }

    public static Mappings getMappings(Side side) {
        URL url = Constants.getResource(Constants.getResourceMappings(side));
        if (url == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStreamReader in = new InputStreamReader(url.openStream());){
                return new MappingsReader().read((Reader)in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (MappingParseException | IOException ex) {
            throw new Error("Couldn't read " + (Object)((Object)side) + " mappings!", ex);
        }
    }

    public static HookLibrary getHooks(Side side) {
        URL url = Constants.getResource(Constants.getResourceHooks(side));
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = url.openStream();){
                HookLibrary library = new HookLibrary();
                library.read(in);
                return library;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new Error("Couldn't read " + (Object)((Object)side) + " hooks!", ex);
        }
    }

    public static TranslationIndex getObfIndex(Side side) {
        try {
            return Constants.newTranslationIndex(Constants.getResource(Constants.getResourceObfIndex(side)));
        }
        catch (IOException ex) {
            throw new Error("Couldn't read " + (Object)((Object)side) + " obfuscated index!", ex);
        }
    }

    public static TranslationIndex getDeobfIndex(Side side) {
        try {
            return Constants.newTranslationIndex(Constants.getResource(Constants.getResourceDeobfIndex(side)));
        }
        catch (IOException ex) {
            throw new Error("Couldn't read " + (Object)((Object)side) + " deobfuscated index!", ex);
        }
    }

    private static TranslationIndex newTranslationIndex(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream in = url.openStream();){
            TranslationIndex index = new TranslationIndex();
            index.read(in);
            return index;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

