/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.eventhandler;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import cuchaz.m3l.M3L;
import cuchaz.m3l.mod.M3LModContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.ASMEventHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.ListenerList;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventBus {
    private static int m_nextBusId = 0;
    private int m_id = m_nextBusId++;
    private Multimap<Object, IEventListener> m_listeners = ArrayListMultimap.create();

    public EventBus() {
        ListenerList.resize((int)(this.m_id + 1));
    }

    public void register(Object target) {
        this.register(target, SubscribeEvent.class);
    }

    public void register(Object target, Class<? extends Annotation> annotationType) {
        M3LModContainer container = M3L.instance.getModContainers().getFromStackTrace();
        if (container == null) {
            M3L.log.error("Called from unknown mod instance. Can't register for events.");
            return;
        }
        Method[] methodArray = target.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(annotationType)) {
                Class<?>[] argTypes = method.getParameterTypes();
                if (argTypes.length <= 0) {
                    M3L.log.warn("Ignoring event handler {}.{}. Method does not accept any arguments.", target.getClass(), (Object)method.getName());
                } else {
                    Class<?> eventType = argTypes[0];
                    if (!Event.class.isAssignableFrom(eventType)) {
                        M3L.log.warn("Ignoring event handler {}.{}. First argument is not an event.", target.getClass(), (Object)method.getName());
                    } else {
                        try {
                            Constructor<?> ctr = eventType.getConstructor(new Class[0]);
                            ctr.setAccessible(true);
                            Event event = (Event)ctr.newInstance(new Object[0]);
                            ASMEventHandler listener = new ASMEventHandler(target, method, (ModContainer)container);
                            event.getListenerList().register(this.m_id, listener.getPriority(), (IEventListener)listener);
                            this.m_listeners.put(target, (Object)listener);
                        }
                        catch (Exception ex) {
                            M3L.log.error("Unable to register event handler {}.{}", new Object[]{target.getClass(), method.getName(), ex});
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public void unregister(Object object) {
        for (IEventListener listener : this.m_listeners.get(object)) {
            ListenerList.unregisterAll((int)this.m_id, (IEventListener)listener);
        }
    }

    public boolean post(Event event) {
        IEventListener[] iEventListenerArray = event.getListenerList().getListeners(this.m_id);
        int n = iEventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEventListener listener = iEventListenerArray[n2];
            listener.invoke(event);
            ++n2;
        }
        return event.isCancelable() && event.isCanceled();
    }
}

