/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.util;

import java.io.File;
import org.apache.commons.lang3.SystemUtils;

public enum OperatingSystem {
    Windows{

        @Override
        public File getMinecraftDir() {
            File dirHome = new File(System.getProperty("user.home"));
            String pathAppData = System.getenv("APPDATA");
            if (pathAppData != null) {
                dirHome = new File(pathAppData);
            }
            return new File(dirHome, ".minecraft");
        }

        @Override
        public boolean isNative(String filename) {
            return filename.endsWith(".dll");
        }
    }
    ,
    Osx{

        @Override
        public File getMinecraftDir() {
            return new File(new File(System.getProperty("user.home")), "Library/Application Support/minecraft");
        }

        @Override
        public boolean isNative(String filename) {
            return filename.endsWith(".jnilib") || filename.endsWith(".dylib");
        }
    }
    ,
    Linux{

        @Override
        public File getMinecraftDir() {
            return new File(new File(System.getProperty("user.home")), ".minecraft");
        }

        @Override
        public boolean isNative(String filename) {
            return filename.endsWith(".so");
        }
    };


    private OperatingSystem() {
    }

    public static OperatingSystem get() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return Windows;
        }
        if (SystemUtils.IS_OS_MAC) {
            return Osx;
        }
        return Linux;
    }

    public static OperatingSystem get(String name) {
        if ((name = name.toLowerCase()).equals("windows") || name.equals("win")) {
            return Windows;
        }
        if (name.equals("osx") || name.equals("mac")) {
            return Osx;
        }
        if (name.equals("linux")) {
            return Linux;
        }
        return null;
    }

    public abstract File getMinecraftDir();

    public abstract boolean isNative(String var1);

    /* synthetic */ OperatingSystem(String string, int n, OperatingSystem operatingSystem) {
        this();
    }
}

