/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cuchaz.enigma.bytecode.ConstPoolEditor;
import cuchaz.enigma.bytecode.InfoType;
import cuchaz.enigma.bytecode.accessors.ConstInfoAccessor;
import cuchaz.m3l.util.BytecodeIndexIterator;
import cuchaz.m3l.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javassist.CtBehavior;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ExceptionTable;

public class BytecodeTools {
    public static byte[] writeBytecode(Bytecode bytecode) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buf);
        try {
            new ConstPoolEditor(bytecode.getConstPool()).writePool(out);
            out.writeShort(bytecode.getMaxStack());
            out.writeShort(bytecode.getMaxLocals());
            out.writeShort(bytecode.getStackDepth());
            out.writeShort(bytecode.getSize());
            out.write(bytecode.get());
            int numEntries = bytecode.getExceptionTable().size();
            out.writeShort(numEntries);
            int i = 0;
            while (i < numEntries) {
                out.writeShort(bytecode.getExceptionTable().startPc(i));
                out.writeShort(bytecode.getExceptionTable().endPc(i));
                out.writeShort(bytecode.getExceptionTable().handlerPc(i));
                out.writeShort(bytecode.getExceptionTable().catchType(i));
                ++i;
            }
            out.close();
            return buf.toByteArray();
        }
        catch (Exception ex) {
            Util.closeQuietly(out);
            throw new Error(ex);
        }
    }

    public static Bytecode readBytecode(byte[] bytes) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(bytes);
        DataInputStream in = new DataInputStream(buf);
        try {
            ConstPool pool = ConstPoolEditor.readPool((DataInputStream)in);
            short maxStack = in.readShort();
            short maxLocals = in.readShort();
            short stackDepth = in.readShort();
            Bytecode bytecode = new Bytecode(pool, (int)maxStack, (int)maxLocals);
            bytecode.setStackDepth((int)stackDepth);
            short size = in.readShort();
            byte[] code = new byte[size];
            in.read(code);
            BytecodeTools.setBytecode(bytecode, code);
            int numEntries = in.readShort();
            int i = 0;
            while (i < numEntries) {
                bytecode.getExceptionTable().add((int)in.readShort(), (int)in.readShort(), (int)in.readShort(), (int)in.readShort());
                ++i;
            }
            in.close();
            return bytecode;
        }
        catch (Exception ex) {
            Util.closeQuietly(in);
            throw new Error(ex);
        }
    }

    public static Bytecode prepareMethodForBytecode(CtBehavior behavior, Bytecode bytecode) throws BadBytecode {
        bytecode = BytecodeTools.copyBytecodeToConstPool(behavior.getMethodInfo().getConstPool(), bytecode);
        CodeAttribute attribute = behavior.getMethodInfo().getCodeAttribute();
        if (bytecode.getMaxLocals() > attribute.getMaxLocals()) {
            attribute.setMaxLocals(bytecode.getMaxLocals());
        }
        if (bytecode.getMaxStack() > attribute.getMaxStack()) {
            attribute.setMaxStack(bytecode.getMaxStack());
        }
        return bytecode;
    }

    public static Bytecode copyBytecodeToConstPool(ConstPool dest, Bytecode bytecode) throws BadBytecode {
        TreeSet indices = Sets.newTreeSet();
        ConstPoolEditor editor = new ConstPoolEditor(bytecode.getConstPool());
        BytecodeIndexIterator iterator = new BytecodeIndexIterator(bytecode);
        for (BytecodeIndexIterator.Index index : iterator.indices()) {
            assert (index.isValid(bytecode));
            InfoType.gatherIndexTree((Collection)indices, (ConstPoolEditor)editor, (int)index.getIndex());
        }
        TreeMap indexMap = Maps.newTreeMap();
        ConstPool src = bytecode.getConstPool();
        ConstPoolEditor editorSrc = new ConstPoolEditor(src);
        ConstPoolEditor editorDest = new ConstPoolEditor(dest);
        for (InfoType type : InfoType.getSortedByLevel()) {
            Iterator<Object> iterator2 = indices.iterator();
            while (iterator2.hasNext()) {
                int index = (Integer)iterator2.next();
                ConstInfoAccessor entry = editorSrc.getItem(index);
                if (entry.getType() != type) continue;
                assert (type.subIndicesAreValid(entry, editorSrc));
                assert (type.selfIndexIsValid(entry, editorSrc));
                ConstInfoAccessor entryCopy = editorSrc.getItem(index).copy();
                assert (type.subIndicesAreValid(entryCopy, editorSrc));
                assert (type.selfIndexIsValid(entryCopy, editorSrc));
                type.remapIndices((Map)indexMap, entryCopy);
                assert (type.subIndicesAreValid(entryCopy, editorDest));
                int newIndex = editorDest.addItem(entryCopy.getItem());
                entryCopy.setIndex(newIndex);
                assert (type.selfIndexIsValid(entryCopy, editorDest)) : type + ", self: " + entryCopy + " dest: " + editorDest.getItem(entryCopy.getIndex());
                assert (type.subIndicesAreValid(entry, editorSrc));
                assert (type.selfIndexIsValid(entry, editorSrc));
                if (indexMap.containsKey(index)) {
                    throw new Error("Entry at index " + index + " already copied!");
                }
                indexMap.put(index, newIndex);
            }
        }
        Bytecode newBytecode = new Bytecode(dest, bytecode.getMaxStack(), bytecode.getMaxLocals());
        bytecode.setStackDepth(bytecode.getStackDepth());
        BytecodeTools.setBytecode(newBytecode, bytecode.get());
        BytecodeTools.setExceptionTable(newBytecode, bytecode.getExceptionTable());
        BytecodeIndexIterator iter = new BytecodeIndexIterator(newBytecode);
        for (BytecodeIndexIterator.Index index : iter.indices()) {
            int oldIndex = index.getIndex();
            Integer newIndex = (Integer)indexMap.get(oldIndex);
            if (newIndex == null) continue;
            InfoType typeSrc = editorSrc.getItem(oldIndex).getType();
            InfoType typeDest = editorDest.getItem(newIndex.intValue()).getType();
            assert (typeSrc == typeDest);
            index.setIndex(newIndex);
        }
        iter.saveChangesToBytecode();
        iter = new BytecodeIndexIterator(newBytecode);
        for (BytecodeIndexIterator.Index index : iter.indices()) {
            assert (index.isValid(newBytecode));
        }
        return newBytecode;
    }

    public static void setBytecode(Bytecode dest, byte[] src) {
        if (src.length > dest.getSize()) {
            dest.addGap(src.length - dest.getSize());
        }
        assert (dest.getSize() == src.length);
        int i = 0;
        while (i < src.length) {
            dest.write(i, (int)src[i]);
            ++i;
        }
    }

    public static void setExceptionTable(Bytecode dest, ExceptionTable src) {
        int size = dest.getExceptionTable().size();
        int i = size - 1;
        while (i >= 0) {
            dest.getExceptionTable().remove(i);
            --i;
        }
        i = 0;
        while (i < src.size()) {
            dest.getExceptionTable().add(src.startPc(i), src.endPc(i), src.handlerPc(i), src.catchType(i));
            ++i;
        }
    }

    public static List<String> getParameterTypes(String signature) {
        ArrayList types = Lists.newArrayList();
        int i = 0;
        while (i < signature.length()) {
            char c = signature.charAt(i);
            if (c == '(') {
                c = signature.charAt(++i);
            }
            if (c == ')') break;
            String type = null;
            int arrayDim = 0;
            while (c == '[') {
                ++arrayDim;
                c = signature.charAt(++i);
            }
            if (c == 'L') {
                int pos = signature.indexOf(59, i + 1);
                String className = signature.substring(i + 1, pos);
                type = "L" + className + ";";
                i = pos + 1;
            } else {
                type = signature.substring(i, i + 1);
                ++i;
            }
            while (arrayDim-- > 0) {
                type = "[" + type;
            }
            types.add(type);
        }
        return types;
    }
}

