/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.tweaker;

import cuchaz.enigma.bytecode.ClassPublifier;
import cuchaz.enigma.bytecode.ClassRenamer;
import cuchaz.enigma.bytecode.ClassTranslator;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.TranslationDirection;
import cuchaz.enigma.mapping.Translator;
import cuchaz.m3l.Constants;
import cuchaz.m3l.Side;
import cuchaz.m3l.classTransformation.ClassFilter;
import cuchaz.m3l.classTransformation.HookInjector;
import cuchaz.m3l.tweaker.ClassType;
import cuchaz.m3l.tweaker.PseudoDeobfClassPath;
import java.io.IOException;
import javassist.ByteArrayClassPath;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;
import net.minecraft.launchwrapper.IClassTransformer;

public class TweakerClassTransformer
implements IClassTransformer {
    private boolean m_isObfuscated;
    private Mappings m_mappings;
    private Translator m_deobfuscator;
    private Translator m_obfuscator;
    private ClassTranslator m_classDeobfuscator;
    private ClassTranslator m_classObfuscator;
    private HookInjector m_injector;
    private ClassFilter m_filter;

    public TweakerClassTransformer(Side side, boolean isObfuscated) {
        this.m_isObfuscated = isObfuscated;
        try {
            this.m_mappings = Constants.getMappings(side);
            if (this.m_isObfuscated) {
                this.m_deobfuscator = this.m_mappings.getTranslator(TranslationDirection.Deobfuscating, Constants.getObfIndex(side));
                this.m_obfuscator = this.m_mappings.getTranslator(TranslationDirection.Obfuscating, Constants.getObfIndex(side));
                this.m_classDeobfuscator = new ClassTranslator(this.m_deobfuscator);
                this.m_classObfuscator = new ClassTranslator(this.m_obfuscator);
            }
            this.m_injector = new HookInjector(Constants.getHooks(side));
            this.m_filter = new ClassFilter(side);
        }
        catch (Exception ex) {
            throw new Error("Unable to load class transformer!", ex);
        }
    }

    public byte[] transform(String name, String sameAsName, byte[] data) {
        if (data == null) {
            return null;
        }
        ClassEntry deobfClassEntry = null;
        if (this.m_isObfuscated) {
            ClassEntry obfClassEntry = new ClassEntry(Descriptor.toJvmName((String)name));
            if (obfClassEntry.isInDefaultPackage()) {
                obfClassEntry = new ClassEntry("none/" + obfClassEntry.getName());
            }
            deobfClassEntry = this.m_deobfuscator.translateEntry(obfClassEntry);
        } else {
            deobfClassEntry = new ClassEntry(Descriptor.toJvmName((String)name));
        }
        ClassType type = ClassType.get(Descriptor.toJavaName((String)deobfClassEntry.getClassName()));
        if (!(type.shouldFilter() || type.shouldHook() || type.shouldTranslate())) {
            return data;
        }
        try {
            ClassPool classPool = new ClassPool();
            classPool.insertClassPath((ClassPath)new PseudoDeobfClassPath(this.m_obfuscator.getTranslationIndex()));
            classPool.insertClassPath((ClassPath)new LoaderClassPath(this.getClass().getClassLoader()));
            classPool.insertClassPath((ClassPath)new ByteArrayClassPath(name, data));
            CtClass c = classPool.get(name);
            if (type.shouldFilter()) {
                this.m_filter.filter(c);
            }
            if (this.m_isObfuscated) {
                ClassRenamer.moveAllClassesOutOfDefaultPackage((CtClass)c, (String)"none");
                if (type.shouldTranslate()) {
                    this.m_classDeobfuscator.translate(c);
                }
            }
            if (type.shouldHook()) {
                ClassPublifier.publify((CtClass)c);
                if (this.m_injector.isClassHooked(deobfClassEntry)) {
                    this.m_injector.transformClass(c);
                }
            } else {
                this.m_obfuscator.getTranslationIndex().indexClass(c, false);
            }
            if (this.m_isObfuscated) {
                if (type.shouldTranslate()) {
                    this.m_classObfuscator.translate(c);
                }
                ClassRenamer.moveAllClassesIntoDefaultPackage((CtClass)c, (String)"none");
            }
            data = c.toBytecode();
        }
        catch (IOException | CannotCompileException | NotFoundException ex) {
            throw new Error(ex);
        }
        return data;
    }
}

