/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.tweaker;

import cuchaz.m3l.Side;
import cuchaz.m3l.discovery.ModDiscoveries;
import cuchaz.m3l.discovery.ModDiscovery;
import cuchaz.m3l.util.Arguments;
import java.io.File;
import java.util.List;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.LaunchClassLoader;

public abstract class Tweaker
implements ITweaker {
    private String m_mainClassName;
    private String m_transformerClassName;
    private Side m_side;
    private Arguments m_args;

    public Tweaker(String mainClassName, String transformerclassName, Side side) {
        this.m_mainClassName = mainClassName;
        this.m_transformerClassName = transformerclassName;
        this.m_side = side;
        this.m_args = new Arguments();
    }

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        int i = 0;
        while (i < args.size()) {
            String arg = args.get(i);
            if (arg.startsWith("--") && i < args.size() - 1) {
                String name = arg.substring(2);
                String value = args.get(i + 1);
                this.m_args.set(name, value);
            }
            ++i;
        }
        File dirGame = new File(System.getProperty("user.dir"));
        this.m_args.set("version", "M3L");
        this.m_args.set("gameDir", dirGame.getAbsolutePath());
        if (this.m_side == Side.Client) {
            this.m_args.set("assetsDir", new File(dirGame, "assets").getAbsolutePath());
        }
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        classLoader.registerTransformer(this.m_transformerClassName);
        ModDiscoveries.getInstance().discoverMods();
        for (ModDiscovery mod : ModDiscoveries.getInstance().discoveries()) {
            mod.injectIntoClassLoader(classLoader);
        }
    }

    public String[] getLaunchArguments() {
        return this.m_args.build();
    }

    public String getLaunchTarget() {
        return this.m_mainClassName;
    }
}

