/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.tweaker;

import cuchaz.enigma.analysis.TranslationIndex;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.m3l.M3L;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;

public class PseudoDeobfClassPath
implements ClassPath {
    private TranslationIndex m_translationIndex;

    public PseudoDeobfClassPath(TranslationIndex translationIndex) {
        this.m_translationIndex = translationIndex;
    }

    public InputStream openClassfile(String classname) throws NotFoundException {
        ClassEntry classEntry = new ClassEntry(Descriptor.toJvmName((String)classname));
        ClassEntry superclassEntry = this.m_translationIndex.getSuperclass(classEntry);
        if (superclassEntry == null) {
            throw new NotFoundException(classname);
        }
        String superclassName = Descriptor.toJavaName((String)superclassEntry.toString());
        ClassPool classPool = new ClassPool();
        classPool.insertClassPath((ClassPath)new LoaderClassPath(this.getClass().getClassLoader()));
        CtClass c = classPool.makeClass(classname, this.isJre(superclassEntry) ? classPool.get(superclassName) : classPool.makeClass(superclassName));
        try {
            return new ByteArrayInputStream(c.toBytecode());
        }
        catch (IOException | CannotCompileException ex) {
            M3L.log.error("Can't generate class/superclass pair", ex);
            throw new NotFoundException(classname);
        }
    }

    public URL find(String classname) {
        ClassEntry classEntry = new ClassEntry(Descriptor.toJvmName((String)classname));
        ClassEntry superclassEntry = this.m_translationIndex.getSuperclass(classEntry);
        if (superclassEntry == null) {
            return null;
        }
        try {
            return new URL(String.format("file:///%s/%s", classEntry.toString(), superclassEntry.toString()));
        }
        catch (MalformedURLException ex) {
            M3L.log.error("Apparently our custom url is malformed... who knew.", (Throwable)ex);
            return null;
        }
    }

    public void close() {
    }

    private boolean isJre(ClassEntry classEntry) {
        String packageName = classEntry.getPackageName();
        return packageName != null && (packageName.startsWith("java") || packageName.startsWith("javax"));
    }
}

