/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.mod;

import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import cuchaz.m3l.M3L;
import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionRange;

public class M3LModContainer
implements ModContainer {
    private Mod m_annotation;
    private Object m_mod;
    private Map<Class<?>, Method> m_lifecycleEventHandlers;

    public M3LModContainer(Mod annotation, Object instance) {
        this.m_annotation = annotation;
        this.m_mod = instance;
        this.m_lifecycleEventHandlers = Maps.newHashMap();
        Class<?> c = this.m_mod.getClass();
        AccessibleObject[] accessibleObjectArray = this.m_mod.getClass().getMethods();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = accessibleObjectArray[n2];
            if (method.isAnnotationPresent(Mod.EventHandler.class)) {
                Class<?>[] argTypes = method.getParameterTypes();
                if (argTypes.length <= 0) {
                    M3L.log.warn("Ignoring event handler {}.{}. Method does not accept any arguments.", c.getClass(), (Object)method.getName());
                } else {
                    Class<?> eventType = argTypes[0];
                    if (!FMLStateEvent.class.isAssignableFrom(eventType)) {
                        M3L.log.warn("Ignoring event handler {}.{}. First argument is not an event.", c.getClass(), (Object)method.getName());
                    } else {
                        this.m_lifecycleEventHandlers.put(eventType, method);
                    }
                }
            }
            ++n2;
        }
        accessibleObjectArray = this.m_mod.getClass().getFields();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject field = accessibleObjectArray[n2];
            if (field.isAnnotationPresent(Mod.Instance.class)) {
                if (!this.m_mod.getClass().isAssignableFrom(((Field)field).getType())) {
                    M3L.log.warn("Ignoring instance field {}.{}. Field has wrong type.", c.getClass(), (Object)((Field)field).getName());
                } else {
                    try {
                        ((Field)field).set(this.m_mod, this.m_mod);
                    }
                    catch (IllegalAccessException | IllegalArgumentException ex) {
                        M3L.log.warn("Ignoring instance field {}.{}. Could not set value.", new Object[]{c.getClass(), ((Field)field).getName(), ex});
                    }
                }
            }
            ++n2;
        }
    }

    public String getModId() {
        return this.m_annotation.modid();
    }

    public String getName() {
        return this.m_annotation.name();
    }

    public String getVersion() {
        return this.m_annotation.version();
    }

    public Object getMod() {
        return this.m_mod;
    }

    public void sendEvent(FMLStateEvent event) {
        Method handler = this.m_lifecycleEventHandlers.get(event.getClass());
        if (handler != null) {
            try {
                handler.invoke(this.m_mod, event);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                M3L.log.error("Couldn't dispatch event to mod: {}", (Object)this.getModId(), (Object)ex);
            }
            catch (InvocationTargetException ex) {
                M3L.log.error("Exception in mod event handler: {}", (Object)this.getModId(), (Object)ex.getCause());
            }
        }
    }

    public VersionRange acceptableMinecraftVersionRange() {
        return null;
    }

    public void bindMetadata(MetadataCollection metadata) {
    }

    public ModContainer.Disableable canBeDisabled() {
        return null;
    }

    public Map<String, String> getCustomModProperties() {
        return null;
    }

    public Class<?> getCustomResourcePackClass() {
        return null;
    }

    public List<ArtifactVersion> getDependants() {
        return null;
    }

    public List<ArtifactVersion> getDependencies() {
        return null;
    }

    public String getDisplayVersion() {
        return null;
    }

    public String getGuiClassName() {
        return null;
    }

    public ModMetadata getMetadata() {
        return null;
    }

    public List<String> getOwnedPackages() {
        return null;
    }

    public ArtifactVersion getProcessedVersion() {
        return null;
    }

    public Set<ArtifactVersion> getRequirements() {
        return null;
    }

    public Map<String, String> getSharedModDescriptor() {
        return null;
    }

    public Certificate getSigningCertificate() {
        return null;
    }

    public String getSortingRules() {
        return null;
    }

    public File getSource() {
        return null;
    }

    public boolean isImmutable() {
        return false;
    }

    public boolean matches(Object obj) {
        return false;
    }

    public boolean registerBus(EventBus bus, LoadController loadController) {
        return false;
    }

    public void setEnabledState(boolean val) {
    }

    public boolean shouldLoadInEnvironment() {
        return false;
    }
}

