/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.discovery;

import com.google.common.collect.Lists;
import cuchaz.m3l.discovery.ModDiscoverer;
import cuchaz.m3l.discovery.ModDiscoveries;
import cuchaz.m3l.discovery.ModDiscovery;
import java.util.ArrayList;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import net.minecraftforge.fml.common.Mod;

public class PropertiesModDiscoverer
implements ModDiscoverer {
    @Override
    public Iterable<ModDiscovery> findMods() {
        ArrayList mods = Lists.newArrayList();
        ClassPool classPool = new ClassPool();
        classPool.appendSystemPath();
        ModDiscoveries.log.info("Looking for mods in the system property {} ...", (Object)"cuchaz.m3l.modClassNames");
        for (String className : ModDiscoveries.getClassNames("cuchaz.m3l.modClassNames")) {
            try {
                CtClass modClass = classPool.get(className);
                AnnotationsAttribute attributeInfo = (AnnotationsAttribute)modClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
                if (attributeInfo == null) {
                    ModDiscoveries.log.warn("Class {} does not have the Mod annotation", (Object)className);
                    continue;
                }
                Annotation annotation = attributeInfo.getAnnotation(Mod.class.getName());
                if (annotation == null) {
                    ModDiscoveries.log.warn("Class {} does not have the Mod annotation", (Object)className);
                    continue;
                }
                MemberValue modIdMember = annotation.getMemberValue("modid");
                if (modIdMember instanceof StringMemberValue) {
                    String modId = ((StringMemberValue)modIdMember).getValue();
                    mods.add(new ModDiscovery(modId, className));
                    ModDiscoveries.log.info("Found mod: {}", (Object)modId);
                    continue;
                }
                ModDiscoveries.log.warn("Mod annotation for Class {} is incorrect or corrupt", (Object)className);
            }
            catch (NotFoundException ex) {
                ModDiscoveries.log.warn("Explicitly specified mod class {} was not found", (Object)className);
            }
        }
        return mods;
    }
}

