/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.discovery;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.JarClassIterator;
import cuchaz.m3l.discovery.ModDiscoverer;
import cuchaz.m3l.discovery.ModDiscoveries;
import cuchaz.m3l.discovery.ModDiscovery;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.jar.JarFile;
import javassist.CtClass;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import net.minecraftforge.fml.common.Mod;

public class ModFolderModDiscoverer
implements ModDiscoverer {
    private static final FilenameFilter m_zipFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };

    @Override
    public Iterable<ModDiscovery> findMods() {
        File[] fileArray;
        ArrayList mods = Lists.newArrayList();
        ModDiscoveries.log.info("Looking for mods in the mods folder...");
        ArrayList files = Lists.newArrayList();
        File dirMods = new File("mods");
        if (dirMods.exists() && dirMods.isDirectory()) {
            fileArray = dirMods.listFiles(m_zipFilter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                files.add(file);
                ++n2;
            }
        }
        for (File file : files) {
            ModDiscoveries.log.info("Checking jar file: {}", (Object)file.getAbsolutePath());
            try {
                Throwable throwable = null;
                fileArray = null;
                try (JarFile jarFile = new JarFile(file);){
                    for (CtClass c : JarClassIterator.classes((JarFile)jarFile)) {
                        Annotation annotation;
                        AnnotationsAttribute attributeInfo = (AnnotationsAttribute)c.getClassFile().getAttribute("RuntimeVisibleAnnotations");
                        if (attributeInfo == null || (annotation = attributeInfo.getAnnotation(Mod.class.getName())) == null) continue;
                        MemberValue modIdMember = annotation.getMemberValue("modid");
                        if (modIdMember instanceof StringMemberValue) {
                            String modId = ((StringMemberValue)modIdMember).getValue();
                            mods.add(new ModDiscovery(modId, c.getName(), file));
                            ModDiscoveries.log.info("Found mod: {}", (Object)modId);
                            continue;
                        }
                        ModDiscoveries.log.warn("Mod annotation for Class {} is incorrect or corrupt", (Object)c.getName());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                ModDiscoveries.log.warn("Unable to check jar file", (Throwable)ex);
            }
        }
        return mods;
    }
}

