/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation.transformers;

import cuchaz.m3l.M3L;
import cuchaz.m3l.Side;
import cuchaz.m3l.api.chunks.ChunkSystem;
import cuchaz.m3l.classTransformation.ClassTransformer;
import cuchaz.m3l.classTransformation.HookCompiler;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;
import net.minecraft.world.WorldClient;
import net.minecraft.world.gen.ClientChunkCache;

public class WorldClientTransformer
implements ClassTransformer {
    @Override
    public boolean meetsRequirements(CtClass c) {
        return c.getName().equals(WorldClient.class.getName());
    }

    @Override
    public void compile(HookCompiler compiler, CtClass c, Side side) throws NotFoundException, CannotCompileException {
        compiler.insertBeforeBehavior((CtBehavior)c.getDeclaredMethod("createChunkCache"), String.valueOf(ClientChunkCache.class.getName()) + " override = " + this.getClass().getName() + ".getChunkCache(this);" + "if (override != null) { this.clientChunkCache = override; return override; }");
        compiler.insertAfterVoidBehavior((CtBehavior)c.getDeclaredMethod("tick"), String.valueOf(this.getClass().getName()) + ".onWorldClientTick(this);");
    }

    public static ClientChunkCache getChunkCache(WorldClient worldClient) {
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null) {
            return chunkSystem.getClientChunkCache(worldClient);
        }
        return null;
    }

    public static void onWorldClientTick(WorldClient worldClient) {
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null) {
            chunkSystem.onWorldClientTick(worldClient);
        }
    }
}

