/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation.transformers;

import cuchaz.m3l.M3L;
import cuchaz.m3l.Side;
import cuchaz.m3l.api.chunks.ChunkSystem;
import cuchaz.m3l.classTransformation.ClassTransformer;
import cuchaz.m3l.classTransformation.HookCompiler;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;
import net.minecraft.world.Dimension;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeManager;

public class DimensionTransformer
implements ClassTransformer {
    @Override
    public boolean meetsRequirements(CtClass c) {
        return c.getName().equals(Dimension.class.getName());
    }

    @Override
    public void compile(HookCompiler compiler, CtClass c, Side side) throws NotFoundException, CannotCompileException {
        compiler.insertBeforeBehavior((CtBehavior)c.getDeclaredMethod("registerBiomeManager"), String.valueOf(BiomeManager.class.getName()) + " override = " + this.getClass().getName() + ".getBiomeManager(this.world);" + "if (override != null) { return override; }");
    }

    public static BiomeManager getBiomeManager(World world) {
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null) {
            return chunkSystem.getBiomeManager(world);
        }
        return null;
    }
}

