/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation.hooks;

import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.m3l.classTransformation.hooks.BehaviorHook;
import cuchaz.m3l.util.BytecodeTools;
import cuchaz.m3l.util.EntryFactory;
import javassist.CtBehavior;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;

public class VirtualCallThenArrayAccessReplacementHook
extends BehaviorHook {
    private static final long serialVersionUID = -2316695172357710161L;
    private BehaviorEntry m_targetBehaviorCall;

    public VirtualCallThenArrayAccessReplacementHook(CtBehavior behavior, byte[] bytecode, BehaviorEntry targetBehaviorCall) {
        super(behavior, bytecode);
        this.m_targetBehaviorCall = targetBehaviorCall;
    }

    @Override
    protected void onApply(CtBehavior behavior, Bytecode bytecode) throws BadBytecode {
        bytecode = BytecodeTools.prepareMethodForBytecode(behavior, bytecode);
        byte[] code = bytecode.get();
        ConstPool pool = behavior.getDeclaringClass().getClassFile().getConstPool();
        CodeAttribute codeAttribute = behavior.getMethodInfo().getCodeAttribute();
        CodeIterator iterator = codeAttribute.iterator();
        block3: while (iterator.hasNext()) {
            int index = iterator.next();
            int opcode = iterator.byteAt(index);
            switch (opcode) {
                case 182: {
                    int aaloadIndex;
                    int methodRefIndex = iterator.byteAt(index + 1) << 8 | iterator.byteAt(index + 2);
                    MethodEntry methodCall = EntryFactory.getMethodEntry(pool, methodRefIndex);
                    if (!methodCall.equals((Object)this.m_targetBehaviorCall) || (aaloadIndex = this.findNextAaload(codeAttribute, index)) < 0) continue block3;
                    int shiftSize = aaloadIndex - index - 3;
                    int i = 0;
                    while (i < shiftSize) {
                        iterator.writeByte(iterator.byteAt(index + i + 3), index + i);
                        ++i;
                    }
                    int replacementVirtualIndex = index + shiftSize;
                    iterator.writeByte((int)code[0], replacementVirtualIndex + 0);
                    iterator.writeByte((int)code[1], replacementVirtualIndex + 1);
                    iterator.writeByte((int)code[2], replacementVirtualIndex + 2);
                    assert (replacementVirtualIndex + 3 == aaloadIndex);
                    iterator.writeByte(0, aaloadIndex);
                    iterator.move(aaloadIndex);
                }
            }
        }
    }

    private int findNextAaload(CodeAttribute codeAttribute, int startIndex) throws BadBytecode {
        CodeIterator iterator = codeAttribute.iterator();
        iterator.move(startIndex);
        while (iterator.hasNext()) {
            int index = iterator.next();
            int opcode = iterator.byteAt(index);
            if (opcode != 50) continue;
            return index;
        }
        return -1;
    }
}

