/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation.hooks;

import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.m3l.classTransformation.hooks.BehaviorHook;
import cuchaz.m3l.util.BytecodeTools;
import cuchaz.m3l.util.EntryFactory;
import cuchaz.m3l.util.Util;
import java.util.ArrayList;
import java.util.List;
import javassist.CtBehavior;
import javassist.Modifier;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;

public class VirtualCallReplacementHook
extends BehaviorHook {
    private static final long serialVersionUID = -8461173566843804486L;
    private BehaviorEntry m_targetBehaviorCall;
    private boolean m_includeArguments;

    public VirtualCallReplacementHook(CtBehavior behavior, byte[] bytecode, BehaviorEntry targetBehaviorCall, boolean includeArguments) {
        super(behavior, bytecode);
        this.m_targetBehaviorCall = targetBehaviorCall;
        this.m_includeArguments = includeArguments;
    }

    @Override
    protected void onApply(CtBehavior behavior, Bytecode bytecode) throws BadBytecode {
        bytecode = BytecodeTools.prepareMethodForBytecode(behavior, bytecode);
        byte[] code = bytecode.get();
        ConstPool pool = behavior.getDeclaringClass().getClassFile().getConstPool();
        ArrayList<String> extraArgs = new ArrayList<String>();
        if (this.m_includeArguments) {
            if (!Modifier.isStatic((int)behavior.getModifiers())) {
                extraArgs.add(Util.getClassDesc(behavior.getDeclaringClass().getName()));
            }
            extraArgs.addAll(Util.getSignatureArguments(behavior.getMethodInfo().getDescriptor()));
        }
        byte[] loadOps = null;
        if (!extraArgs.isEmpty()) {
            loadOps = this.createLoadOps(extraArgs);
        }
        CodeIterator iterator = behavior.getMethodInfo().getCodeAttribute().iterator();
        while (iterator.hasNext()) {
            int index = iterator.next();
            int opcode = iterator.byteAt(index);
            switch (opcode) {
                case 182: {
                    int methodRefIndex = iterator.byteAt(index + 1) << 8 | iterator.byteAt(index + 2);
                    MethodEntry methodCall = EntryFactory.getMethodEntry(pool, methodRefIndex);
                    if (!methodCall.equals((Object)this.m_targetBehaviorCall)) break;
                    iterator.writeByte((int)code[0], index + 0);
                    iterator.writeByte((int)code[1], index + 1);
                    iterator.writeByte((int)code[2], index + 2);
                    if (loadOps == null) break;
                    iterator.insertAt(index, loadOps);
                }
            }
        }
        if (extraArgs.size() > 0) {
            CodeAttribute attribute = behavior.getMethodInfo().getCodeAttribute();
            attribute.computeMaxStack();
        }
    }

    private byte[] createLoadOps(List<String> extraArgs) {
        ArrayList<Byte> ops = new ArrayList<Byte>();
        int pos = 0;
        for (String arg : extraArgs) {
            pos += this.addArgLoadOps(ops, arg, pos);
        }
        byte[] loadOps = new byte[ops.size()];
        int i = 0;
        while (i < loadOps.length) {
            loadOps[i] = (Byte)ops.get(i);
            ++i;
        }
        return loadOps;
    }

    private int addArgLoadOps(List<Byte> ops, String arg, int i) {
        switch (arg.charAt(0)) {
            case 'L': 
            case '[': {
                switch (i) {
                    case 0: {
                        ops.add((byte)42);
                        break;
                    }
                    case 1: {
                        ops.add((byte)43);
                        break;
                    }
                    case 2: {
                        ops.add((byte)44);
                        break;
                    }
                    case 3: {
                        ops.add((byte)45);
                        break;
                    }
                    default: {
                        ops.add((byte)25);
                        ops.add((byte)i);
                    }
                }
                return 1;
            }
            case 'D': {
                switch (i) {
                    case 0: {
                        ops.add((byte)38);
                        break;
                    }
                    case 1: {
                        ops.add((byte)39);
                        break;
                    }
                    case 2: {
                        ops.add((byte)40);
                        break;
                    }
                    case 3: {
                        ops.add((byte)41);
                        break;
                    }
                    default: {
                        ops.add((byte)49);
                        ops.add((byte)i);
                    }
                }
                return 2;
            }
            case 'F': {
                switch (i) {
                    case 0: {
                        ops.add((byte)34);
                        break;
                    }
                    case 1: {
                        ops.add((byte)35);
                        break;
                    }
                    case 2: {
                        ops.add((byte)36);
                        break;
                    }
                    case 3: {
                        ops.add((byte)37);
                        break;
                    }
                    default: {
                        ops.add((byte)48);
                        ops.add((byte)i);
                    }
                }
                return 1;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                switch (i) {
                    case 0: {
                        ops.add((byte)26);
                        break;
                    }
                    case 1: {
                        ops.add((byte)27);
                        break;
                    }
                    case 2: {
                        ops.add((byte)28);
                        break;
                    }
                    case 3: {
                        ops.add((byte)29);
                        break;
                    }
                    default: {
                        ops.add((byte)46);
                        ops.add((byte)i);
                    }
                }
                return 1;
            }
            case 'J': {
                switch (i) {
                    case 0: {
                        ops.add((byte)30);
                        break;
                    }
                    case 1: {
                        ops.add((byte)31);
                        break;
                    }
                    case 2: {
                        ops.add((byte)32);
                        break;
                    }
                    case 3: {
                        ops.add((byte)33);
                        break;
                    }
                    default: {
                        ops.add((byte)47);
                        ops.add((byte)i);
                    }
                }
                return 2;
            }
        }
        throw new Error("Unknown type: " + arg);
    }
}

