/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation.hooks;

import cuchaz.enigma.bytecode.ConstPoolEditor;
import cuchaz.enigma.bytecode.InfoType;
import cuchaz.m3l.classTransformation.hooks.BehaviorHook;
import cuchaz.m3l.util.BytecodeTools;
import javassist.CtBehavior;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;

public class IntReplacementHook
extends BehaviorHook {
    private static final long serialVersionUID = -1079931895658437052L;
    private int m_val;

    public IntReplacementHook(CtBehavior behavior, int val, byte[] bytecode) {
        super(behavior, bytecode);
        this.m_val = val;
    }

    @Override
    protected void onApply(CtBehavior behavior, Bytecode bytecode) throws BadBytecode {
        bytecode = BytecodeTools.prepareMethodForBytecode(behavior, bytecode);
        ConstPool constPool = behavior.getDeclaringClass().getClassFile().getConstPool();
        ConstPoolEditor editor = new ConstPoolEditor(constPool);
        CodeIterator iterator = behavior.getMethodInfo().getCodeAttribute().iterator();
        while (iterator.hasNext()) {
            int index = iterator.next();
            int opcode = iterator.byteAt(index);
            int numBytes = 0;
            int oldVal = 0;
            switch (opcode) {
                case 16: {
                    numBytes = 2;
                    oldVal = iterator.byteAt(index + 1);
                    break;
                }
                case 17: {
                    numBytes = 3;
                    oldVal = iterator.byteAt(index + 1) << 8 | iterator.byteAt(index + 2);
                    break;
                }
                case 14: {
                    numBytes = 1;
                    oldVal = 0;
                    break;
                }
                case 15: {
                    numBytes = 1;
                    oldVal = 1;
                    break;
                }
                case 18: {
                    int constIndex = iterator.byteAt(index + 1);
                    if (editor.getItem(constIndex).getType() != InfoType.IntegerInfo) break;
                    numBytes = 2;
                    oldVal = constPool.getIntegerInfo(constIndex);
                    break;
                }
                case 19: {
                    int constIndex = iterator.byteAt(index + 1) << 8 | iterator.byteAt(index + 2);
                    if (editor.getItem(constIndex).getType() != InfoType.IntegerInfo) break;
                    numBytes = 3;
                    oldVal = constPool.getIntegerInfo(constIndex);
                }
            }
            if (numBytes <= 0 || oldVal != this.m_val) continue;
            int spaceNeeded = bytecode.getSize() - numBytes;
            if (spaceNeeded > 0) {
                iterator.insertGap(spaceNeeded);
            }
            iterator.write(bytecode.get(), index);
            behavior.getMethodInfo().getCodeAttribute().computeMaxStack();
        }
    }
}

