/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation.hooks;

import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.m3l.util.BytecodeTools;
import java.io.IOException;
import java.io.Serializable;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;

public abstract class BehaviorHook
implements Serializable {
    private static final long serialVersionUID = -5345949606532667041L;
    private BehaviorEntry m_behaviorEntry;
    private byte[] m_savedBytecode;

    protected BehaviorHook(CtBehavior behaviorEntry, byte[] savedBytecode) {
        this.m_behaviorEntry = EntryFactory.getBehaviorEntry((CtBehavior)behaviorEntry);
        this.m_savedBytecode = savedBytecode;
    }

    public BehaviorEntry getBehaviorEntry() {
        return this.m_behaviorEntry;
    }

    public void apply(CtBehavior behavior) throws BadBytecode, IOException {
        BehaviorEntry behaviorEntry = EntryFactory.getBehaviorEntry((CtBehavior)behavior);
        if (!behaviorEntry.equals(this.m_behaviorEntry)) {
            throw new IllegalArgumentException(String.format("Behavior to transform %s() does not match hooked behavior %s()", behaviorEntry, this.m_behaviorEntry));
        }
        this.onApply(behavior, BytecodeTools.readBytecode(this.m_savedBytecode));
        CtClass c = behavior.getDeclaringClass();
        behavior.getMethodInfo().rebuildStackMapIf6(c.getClassPool(), c.getClassFile2());
    }

    protected abstract void onApply(CtBehavior var1, Bytecode var2) throws BadBytecode;
}

