/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation;

import com.google.common.collect.Lists;
import cuchaz.enigma.bytecode.ConstPoolEditor;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.Type;
import cuchaz.m3l.classTransformation.hooks.BehaviorHook;
import cuchaz.m3l.classTransformation.hooks.ClassHook;
import cuchaz.m3l.classTransformation.hooks.DoubleReplacementHook;
import cuchaz.m3l.classTransformation.hooks.GtZeroReplacementHook;
import cuchaz.m3l.classTransformation.hooks.InsertAfterVoidBehaviorHook;
import cuchaz.m3l.classTransformation.hooks.InsertBeforeBehaviorHook;
import cuchaz.m3l.classTransformation.hooks.InsertBeforeReturnHook;
import cuchaz.m3l.classTransformation.hooks.IntReplacementHook;
import cuchaz.m3l.classTransformation.hooks.LtZeroReplacementHook;
import cuchaz.m3l.classTransformation.hooks.ReplaceBehaviorHook;
import cuchaz.m3l.classTransformation.hooks.VirtualCallReplacementHook;
import cuchaz.m3l.classTransformation.hooks.VirtualCallThenArrayAccessReplacementHook;
import cuchaz.m3l.util.BytecodeTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.Descriptor;
import javassist.bytecode.MethodInfo;
import javassist.compiler.CompileError;
import javassist.compiler.Javac;

public class HookCompiler {
    private List<ClassHook> m_classHooks = Lists.newArrayList();
    private List<BehaviorHook> m_behaviorHooks = Lists.newArrayList();

    public Iterable<ClassHook> classHooks() {
        return this.m_classHooks;
    }

    public Iterable<BehaviorHook> behaviorHooks() {
        return this.m_behaviorHooks;
    }

    public int getNumHooks() {
        return this.m_classHooks.size() + this.m_behaviorHooks.size();
    }

    public void replaceBehavior(CtBehavior behavior) throws NotFoundException, CannotCompileException {
        this.m_behaviorHooks.add(new ReplaceBehaviorHook(behavior, this.compile(behavior)));
    }

    public void insertBeforeBehavior(CtBehavior behavior, String code) throws NotFoundException, CannotCompileException {
        this.m_behaviorHooks.add(new InsertBeforeBehaviorHook(behavior, this.compile(behavior, code)));
    }

    public void insertAfterVoidBehavior(CtBehavior behavior, String code) throws NotFoundException, CannotCompileException {
        if (behavior instanceof CtMethod && ((CtMethod)behavior).getReturnType() != CtClass.voidType) {
            throw new IllegalArgumentException(String.valueOf(behavior.getDeclaringClass().getName()) + "." + behavior.getName() + "() was not a void method!");
        }
        this.m_behaviorHooks.add(new InsertAfterVoidBehaviorHook(behavior, this.compile(behavior, code)));
    }

    public void insertBeforeReturn(CtBehavior behavior, String code) throws NotFoundException, CannotCompileException {
        this.m_behaviorHooks.add(new InsertBeforeReturnHook(behavior, this.compile(behavior, code)));
    }

    public void replaceInt(CtBehavior behavior, int val, ClassEntry replacementClassEntry, String replacementMethodName, String args) throws NotFoundException, CannotCompileException {
        byte[] bytecode = this.compileInvokeStaticLoadArgsKeepReturnValue(behavior, replacementClassEntry, replacementMethodName, args);
        this.m_behaviorHooks.add(new IntReplacementHook(behavior, val, bytecode));
    }

    public void replaceDouble(CtBehavior behavior, double val, ClassEntry replacementClassEntry, String replacementMethodName, String args) throws NotFoundException, CannotCompileException {
        byte[] bytecode = this.compileInvokeStaticLoadArgsKeepReturnValue(behavior, replacementClassEntry, replacementMethodName, args);
        this.m_behaviorHooks.add(new DoubleReplacementHook(behavior, val, bytecode));
    }

    public void replaceGtZero(CtBehavior behavior, ClassEntry replacementClassEntry, String replacementMethodName, String args) throws NotFoundException, CannotCompileException {
        byte[] bytecode = this.compileInvokeStaticLoadArgsKeepReturnValue(behavior, replacementClassEntry, replacementMethodName, args);
        this.m_behaviorHooks.add(new GtZeroReplacementHook(behavior, bytecode));
    }

    public void replaceLtZero(CtBehavior behavior, ClassEntry replacementClassEntry, String replacementMethodName, String args) throws NotFoundException, CannotCompileException {
        byte[] bytecode = this.compileInvokeStaticLoadArgsKeepReturnValue(behavior, replacementClassEntry, replacementMethodName, args);
        this.m_behaviorHooks.add(new LtZeroReplacementHook(behavior, bytecode));
    }

    public void replaceVirtualCall(CtBehavior behavior, BehaviorEntry targetBehaviorCall, ClassEntry replacementClassEntry, String replacementMethodName) throws NotFoundException, CannotCompileException {
        this.replaceVirtualCall(behavior, targetBehaviorCall, replacementClassEntry, replacementMethodName, false);
    }

    public void replaceVirtualCall(CtBehavior behavior, BehaviorEntry targetBehaviorCall, ClassEntry replacementClassEntry, String replacementMethodName, boolean includeArguments) throws NotFoundException, CannotCompileException {
        ArrayList<Type> types = new ArrayList<Type>();
        types.add(new Type(targetBehaviorCall.getClassEntry()));
        for (Type type : targetBehaviorCall.getSignature().getArgumentTypes()) {
            types.add(type);
        }
        if (includeArguments) {
            BehaviorEntry behaviorEntry = EntryFactory.getBehaviorEntry((CtBehavior)behavior);
            if (!Modifier.isStatic((int)behavior.getModifiers())) {
                types.add(new Type(behaviorEntry.getClassEntry()));
            }
            for (Type type : behaviorEntry.getSignature().getArgumentTypes()) {
                types.add(type);
            }
        }
        StringBuilder buf = new StringBuilder();
        for (Type type : types) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            if (type.isClass()) {
                buf.append("(" + Descriptor.toJavaName((String)type.getClassEntry().getName()) + ")null");
                continue;
            }
            if (type.isArray()) {
                Type arrayType = type.getArrayType();
                if (arrayType.isClass()) {
                    buf.append("(" + Descriptor.toJavaName((String)arrayType.getClassEntry().getName()) + "[])null");
                    continue;
                }
                if (!arrayType.isPrimitive()) continue;
                buf.append("(" + arrayType.getPrimitive().name() + "[])null");
                continue;
            }
            if (!type.isPrimitive()) continue;
            if (type.getPrimitive() == Type.Primitive.Character) {
                buf.append("'0'");
                continue;
            }
            if (type.getPrimitive() == Type.Primitive.Boolean) {
                buf.append("false");
                continue;
            }
            buf.append("0");
        }
        byte[] bytecode = this.compileInvokeStatic(behavior, replacementClassEntry, replacementMethodName, buf.toString());
        this.m_behaviorHooks.add(new VirtualCallReplacementHook(behavior, bytecode, targetBehaviorCall, includeArguments));
    }

    public void replaceVirtualCallThenArrayAccess(CtBehavior behavior, BehaviorEntry targetBehaviorCall, ClassEntry replacementClassEntry, String replacementMethodName) throws NotFoundException, CannotCompileException {
        byte[] bytecode = this.compileInvokeStatic(behavior, replacementClassEntry, replacementMethodName, "null, 0");
        this.m_behaviorHooks.add(new VirtualCallThenArrayAccessReplacementHook(behavior, bytecode, targetBehaviorCall));
    }

    private byte[] compile(CtBehavior behavior, String code) throws NotFoundException, CannotCompileException {
        try {
            CtClass c = behavior.getDeclaringClass();
            MethodInfo info = behavior.getMethodInfo();
            CodeAttribute attribute = info.getCodeAttribute();
            Bytecode bytecode = new Bytecode(c.getClassFile().getConstPool(), 0, attribute.getMaxLocals() + 1);
            bytecode.setStackDepth(attribute.getMaxStack() + 1);
            Javac compiler = new Javac(bytecode, c);
            int numArgs = compiler.recordParams(behavior.getParameterTypes(), Modifier.isStatic((int)behavior.getModifiers()));
            compiler.recordParamNames(attribute, numArgs);
            compiler.recordLocalVariables(attribute, 0);
            compiler.recordReturnType(Descriptor.getReturnType((String)info.getDescriptor(), (ClassPool)c.getClassPool()), true);
            compiler.compileStmnt(code);
            bytecode = BytecodeTools.copyBytecodeToConstPool(ConstPoolEditor.newConstPool(), bytecode);
            return BytecodeTools.writeBytecode(bytecode);
        }
        catch (BadBytecode | CompileError ex) {
            throw new CannotCompileException(ex);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    private byte[] compile(CtBehavior behavior) throws NotFoundException, CannotCompileException {
        try {
            MethodInfo info = behavior.getMethodInfo();
            CodeAttribute attribute = info.getCodeAttribute();
            Bytecode bytecode = new Bytecode(info.getConstPool(), attribute.getMaxStack(), attribute.getMaxLocals());
            BytecodeTools.setBytecode(bytecode, attribute.getCode());
            BytecodeTools.setExceptionTable(bytecode, attribute.getExceptionTable());
            bytecode = BytecodeTools.copyBytecodeToConstPool(ConstPoolEditor.newConstPool(), bytecode);
            return BytecodeTools.writeBytecode(bytecode);
        }
        catch (BadBytecode ex) {
            throw new CannotCompileException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    private byte[] compileInvokeStatic(CtBehavior behavior, ClassEntry classEntry, String accessorName, String args) throws NotFoundException, CannotCompileException {
        try {
            String code = String.format("%s.%s(%s);", Descriptor.toJavaName((String)classEntry.getName()), accessorName, args);
            byte[] encodedBytecode = this.compile(behavior, code);
            Bytecode bytecode = BytecodeTools.readBytecode(encodedBytecode);
            Bytecode newBytecode = new Bytecode(bytecode.getConstPool(), bytecode.getMaxStack(), bytecode.getMaxLocals());
            newBytecode.addGap(3);
            CodeIterator iterator = bytecode.toCodeAttribute().iterator();
            while (iterator.hasNext()) {
                int index = iterator.next();
                int opcode = iterator.byteAt(index);
                if (opcode != 184) continue;
                newBytecode.write(0, opcode);
                newBytecode.write(1, iterator.byteAt(index + 1) & 0xFF);
                newBytecode.write(2, iterator.byteAt(index + 2) & 0xFF);
                break;
            }
            return BytecodeTools.writeBytecode(newBytecode);
        }
        catch (BadBytecode ex) {
            throw new CannotCompileException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    private byte[] compileInvokeStaticLoadArgsKeepReturnValue(CtBehavior behavior, ClassEntry classEntry, String accessorName, String args) throws NotFoundException, CannotCompileException {
        String code = String.format("%s.%s(%s);", Descriptor.toJavaName((String)classEntry.getName()), accessorName, args);
        byte[] encodedBytecode = this.compile(behavior, code);
        try {
            Bytecode bytecode = BytecodeTools.readBytecode(encodedBytecode);
            Bytecode newBytecode = new Bytecode(bytecode.getConstPool(), bytecode.getMaxStack(), bytecode.getMaxLocals());
            CodeIterator readIterator = bytecode.toCodeAttribute().iterator();
            int size = -1;
            while (readIterator.hasNext()) {
                int index = readIterator.next();
                int opcode = readIterator.byteAt(index);
                if (opcode != 184) continue;
                size = index + 3;
                break;
            }
            assert (size >= 0);
            newBytecode.addGap(size);
            int i = 0;
            while (i < size) {
                newBytecode.write(i, bytecode.read(i));
                ++i;
            }
            return BytecodeTools.writeBytecode(newBytecode);
        }
        catch (BadBytecode ex) {
            throw new CannotCompileException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    private void dumpOpcodes(Bytecode bytecode) throws BadBytecode {
        System.out.println("opcodes");
        CodeIterator iterator = bytecode.toCodeAttribute().iterator();
        while (iterator.hasNext()) {
            int index = iterator.next();
            int opcode = iterator.byteAt(index);
            System.out.println("\t" + Integer.toHexString(opcode));
        }
    }
}

