/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l;

import cuchaz.m3l.Side;
import cuchaz.m3l.util.Arguments;
import net.minecraft.launchwrapper.Launch;

public class MainLauncher {
    public static void main(String[] args) throws Throwable {
        try {
            if (args.length < 1) {
                throw new IllegalArgumentException("side is a required argument");
            }
            Side side = Side.get(args[0]);
            boolean isDev = false;
            if (args.length >= 2 && args[1].toLowerCase().equals("dev")) {
                isDev = true;
            }
            Arguments arguments = new Arguments();
            arguments.set("tweakClass", String.format("cuchaz.m3l.tweaker.Tweaker%s%s", side.name(), isDev ? "Dev" : ""));
            switch (side) {
                case Client: {
                    arguments.set("userProperties", "{}");
                    arguments.set("accessToken", "M3Luser");
                    break;
                }
            }
            arguments.set(args, 2, args.length - 1);
            System.out.println("Launching Minecraft...");
            Launch.main((String[])arguments.build());
        }
        catch (IllegalArgumentException ex) {
            MainLauncher.printHelp();
            return;
        }
    }

    private static void printHelp() {
        System.out.println("Magic Mojo Mod Loader (M3L) - v1.8.3-0.3b");
        System.out.println("Launch arguments:");
        System.out.println("\tside [other Minercaft args]");
        System.out.println("where side is \"client\" or \"server\"");
        System.out.println("and [other Minecraft args] can be any normal Minecraft args like --nogui");
    }
}

