/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.util;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.jar.JarFile;
import javassist.CtClass;
import javassist.bytecode.Descriptor;

public class Util {
    public static String joinPaths(String a, String b) {
        return new File(new File(a), b).getPath();
    }

    public static int combineHashesOrdered(Object ... objs) {
        int prime = 67;
        int result = 1;
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            result *= 67;
            if (obj != null) {
                result += obj.hashCode();
            }
            ++n2;
        }
        return result;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(JarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getClassDesc(String className) {
        return "L" + Descriptor.toJvmName((String)className) + ";";
    }

    public static String getClassDesc(Class<?> c) {
        if (c.isArray()) {
            return Descriptor.toJvmName((String)c.getName());
        }
        return "L" + Descriptor.toJvmName((String)c.getName()) + ";";
    }

    public static List<String> getSignatureArguments(String signature) {
        ArrayList<String> out = new ArrayList<String>();
        int i = 0;
        while (i < signature.length()) {
            char c = signature.charAt(i);
            if (c != '(') {
                if (c == ')') break;
                int start = i;
                while (c == '[') {
                    c = signature.charAt(++i);
                }
                if (c == 'L') {
                    i = signature.indexOf(59, i);
                }
                out.add(signature.substring(start, i + 1));
            }
            ++i;
        }
        assert (Descriptor.numOfParameters((String)signature) == out.size());
        return out;
    }

    public static void writeClass(CtClass c, File file) {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(file);
                c.getClassFile().write(new DataOutputStream(out));
                System.out.println("Wrote class " + c.getName() + " to\n\t" + file.getAbsolutePath());
            }
            catch (Exception ex) {
                throw new Error(ex);
            }
        }
        catch (Throwable throwable) {
            Util.closeQuietly(out);
            throw throwable;
        }
        Util.closeQuietly(out);
    }

    public static int randRange(Random rand, int lower, int upper) {
        return rand.nextInt(upper - lower + 1) + lower;
    }
}

