/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import cuchaz.m3l.M3L;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.util.RegistryNamespaced;

public class IdNumberMappings {
    private BiMap<Integer, String> m_numberToId = HashBiMap.create();

    public void loadFromRegistry(RegistryNamespaced registry) {
        for (String id : registry.getRegistryKeys()) {
            int number = registry.getIndexOf(registry.get((Object)id));
            this.m_numberToId.put((Object)number, (Object)id);
        }
    }

    public void write(OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeInt(this.m_numberToId.size());
        for (Map.Entry entry : this.m_numberToId.entrySet()) {
            dout.writeShort((Integer)entry.getKey());
            dout.writeUTF((String)entry.getValue());
        }
    }

    public void read(InputStream in) throws IOException {
        this.m_numberToId.clear();
        DataInputStream din = new DataInputStream(in);
        int numEntries = din.readInt();
        int i = 0;
        while (i < numEntries) {
            short number = din.readShort();
            String id = din.readUTF();
            this.m_numberToId.put((Object)number, (Object)id);
            ++i;
        }
    }

    public String getId(int number) {
        return (String)this.m_numberToId.get((Object)number);
    }

    public boolean equals(Object other) {
        if (other instanceof IdNumberMappings) {
            return this.equals((IdNumberMappings)other);
        }
        return false;
    }

    public boolean equals(IdNumberMappings other) {
        return this.m_numberToId.equals(other.m_numberToId);
    }

    public void restoreRegistry(RegistryNamespaced registry) {
        HashSet ids = new HashSet(this.m_numberToId.values());
        for (String id : ids) {
            int savedNumber = (Integer)this.m_numberToId.inverse().get((Object)id);
            if (savedNumber == 0) continue;
            Object obj = registry.get((Object)id);
            int currentNumber = registry.getIndexOf(obj);
            if (obj == null || currentNumber <= 0) {
                M3L.log.warn("Unable to restore number for " + id + ". This object will not be available in the registry.");
                continue;
            }
            if (currentNumber == savedNumber) continue;
            Object usurperObj = registry.getObjectAtIndex(savedNumber);
            String usurperId = null;
            registry.set(savedNumber, (Object)id, obj);
            registry.set(currentNumber, usurperId, usurperObj);
            M3L.log.info("Restored " + id + " to number " + savedNumber + " and displaced " + usurperId + " to number " + currentNumber);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        ArrayList numbers = Lists.newArrayList((Iterable)this.m_numberToId.keySet());
        Collections.sort(numbers);
        for (Integer number : numbers) {
            String id = (String)this.m_numberToId.get((Object)number);
            buf.append(String.format("%4d   %s\n", number, id));
        }
        return buf.toString();
    }
}

