/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.util;

import cuchaz.m3l.util.BytecodeTools;
import java.util.Iterator;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;

public class BytecodeIndexIterator
implements Iterator<Index> {
    private Bytecode m_bytecode;
    private CodeAttribute m_attribute;
    private CodeIterator m_iter;
    private Index m_next;

    public BytecodeIndexIterator(Bytecode bytecode) throws BadBytecode {
        this.m_bytecode = bytecode;
        this.m_attribute = bytecode.toCodeAttribute();
        this.m_iter = this.m_attribute.iterator();
        this.m_next = this.getNext();
    }

    @Override
    public boolean hasNext() {
        return this.m_next != null;
    }

    @Override
    public Index next() {
        Index out = this.m_next;
        try {
            this.m_next = this.getNext();
        }
        catch (BadBytecode ex) {
            throw new Error(ex);
        }
        return out;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Index getNext() throws BadBytecode {
        while (this.m_iter.hasNext()) {
            int pos = this.m_iter.next();
            int opcode = this.m_iter.byteAt(pos);
            switch (opcode) {
                case 19: 
                case 20: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 189: 
                case 192: 
                case 193: 
                case 197: {
                    return new Index(this.m_iter, pos + 1, true);
                }
                case 18: {
                    return new Index(this.m_iter, pos + 1, false);
                }
            }
        }
        return null;
    }

    public Iterable<Index> indices() {
        return new Iterable<Index>(){

            @Override
            public Iterator<Index> iterator() {
                return BytecodeIndexIterator.this;
            }
        };
    }

    public void saveChangesToBytecode() {
        BytecodeTools.setBytecode(this.m_bytecode, this.m_attribute.getCode());
    }

    public static class Index {
        private CodeIterator m_iter;
        private int m_pos;
        private boolean m_isWide;

        protected Index(CodeIterator iter, int pos, boolean isWide) {
            this.m_iter = iter;
            this.m_pos = pos;
            this.m_isWide = isWide;
        }

        public int getIndex() {
            if (this.m_isWide) {
                return this.m_iter.s16bitAt(this.m_pos);
            }
            return this.m_iter.byteAt(this.m_pos);
        }

        public void setIndex(int val) throws BadBytecode {
            if (this.m_isWide) {
                this.m_iter.write16bit(val, this.m_pos);
            } else if (val < 256) {
                this.m_iter.writeByte(val, this.m_pos);
            } else {
                assert (this.m_iter.byteAt(this.m_pos - 1) == 18);
                this.m_iter.insertGap(this.m_pos - 1, 1);
                this.m_iter.writeByte(19, this.m_pos - 1);
                this.m_iter.write16bit(val, this.m_pos);
                this.m_isWide = true;
                this.m_iter.move(this.m_pos + 2);
            }
            assert (val == this.getIndex());
        }

        public boolean isValid(Bytecode bytecode) {
            return this.getIndex() >= 0 && this.getIndex() < bytecode.getConstPool().getSize();
        }
    }
}

