/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.discovery;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cuchaz.m3l.discovery.ModDiscoverer;
import cuchaz.m3l.discovery.ModDiscovery;
import cuchaz.m3l.discovery.ModFolderModDiscoverer;
import cuchaz.m3l.discovery.PropertiesModDiscoverer;
import cuchaz.m3l.util.Logging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class ModDiscoveries {
    public static final Logger log = Logging.getLogger();
    public static final String DesiredModClassNamesKey = "cuchaz.m3l.modClassNames";
    public static final String DiscoveredModClassNamesKey = "cuchaz.m3l.discoveredModClassNames";
    private static final ModDiscoveries m_instance = new ModDiscoveries();
    private Map<String, ModDiscovery> m_discoveries = Maps.newHashMap();

    public static ModDiscoveries getInstance() {
        return m_instance;
    }

    private ModDiscoveries() {
    }

    public void discoverMods() {
        if (!this.m_discoveries.isEmpty()) {
            return;
        }
        log.info("Discovering mods...");
        ArrayList<ModDiscoverer> discoverers = new ArrayList<ModDiscoverer>();
        discoverers.add(new PropertiesModDiscoverer());
        discoverers.add(new ModFolderModDiscoverer());
        for (ModDiscoverer discoverer : discoverers) {
            for (ModDiscovery discovery : discoverer.findMods()) {
                if (this.m_discoveries.containsKey(discovery.getId())) {
                    log.warn("Ignoring duplicate mod: {}", (Object)discovery.getId());
                    continue;
                }
                this.m_discoveries.put(discovery.getId(), discovery);
            }
        }
        this.m_discoveries = Collections.unmodifiableMap(this.m_discoveries);
        log.info("Discovered {} mods", (Object)this.m_discoveries.size());
        StringBuilder buf = new StringBuilder();
        for (ModDiscovery discovery : this.m_discoveries.values()) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(discovery.getClassName());
        }
        System.setProperty(DiscoveredModClassNamesKey, buf.toString());
    }

    public Collection<ModDiscovery> discoveries() {
        return this.m_discoveries.values();
    }

    public static List<String> getClassNames(String key) {
        ArrayList classNames = Lists.newArrayList();
        String val = System.getProperty(key);
        if (val != null) {
            String[] stringArray = val.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                classNames.add(className);
                ++n2;
            }
        }
        return classNames;
    }
}

