/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation.transformers;

import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.m3l.M3L;
import cuchaz.m3l.Side;
import cuchaz.m3l.api.chunks.ChunkSystem;
import cuchaz.m3l.classTransformation.ClassTransformer;
import cuchaz.m3l.classTransformation.HookCompiler;
import cuchaz.m3l.util.EntryFactory;
import cuchaz.m3l.util.Util;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class WorldTransformer
implements ClassTransformer {
    private static ClassEntry m_thisClass = EntryFactory.getClassEntry(WorldTransformer.class);

    @Override
    public boolean meetsRequirements(CtClass c) {
        return c.getName().equals(World.class.getName());
    }

    @Override
    public void compile(HookCompiler compiler, CtClass c, Side side) throws NotFoundException, CannotCompileException {
        String me = this.getClass().getName();
        String blockPosType = Util.getClassDesc(BlockPos.class);
        String entityType = Util.getClassDesc(Entity.class);
        String lightTypeType = Util.getClassDesc(LightType.class);
        compiler.insertBeforeBehavior((CtBehavior)c.getDeclaredMethod("getSeaLevel"), "Integer override = " + me + ".getSeaLevel(this);" + "if (override != null) { return override.intValue(); };");
        compiler.insertBeforeBehavior((CtBehavior)c.getDeclaredMethod("getHorizonLevel"), "Double override = " + me + ".getHorizonLevel(this);" + "if (override != null) { return override.doubleValue(); };");
        compiler.insertBeforeBehavior((CtBehavior)c.getMethod("updateLightingAt", "(" + blockPosType + ")Z"), "Boolean override = " + me + ".updateLightingAt(this, $$);" + "if (override != null) { return override.booleanValue(); }");
        compiler.insertBeforeBehavior((CtBehavior)c.getMethod("checkBlockRangeIsInWorld", "(IIIIIIZ)Z"), "Boolean override = " + me + ".checkBlockRangeIsInWorld(this, $$);" + "if (override != null) { return override.booleanValue(); }");
        compiler.replaceVirtualCall((CtBehavior)c.getMethod("updateEntity", "(" + entityType + "Z)V"), EntryFactory.getBehaviorEntry(World.class, "checkBlockRangeIsInWorld", "(IIIIIIZ)Z", new Class[0]), m_thisClass, "checkChunksExistForEntityUpdate", true);
        compiler.insertBeforeBehavior((CtBehavior)c.getMethod("getHeight", "()I"), "return " + me + ".getBuildHeight(this);");
        compiler.insertBeforeBehavior((CtBehavior)c.getMethod("getActualHeight", "()I"), "return " + me + ".getBuildHeight(this);");
        CtMethod method = c.getMethod("isBlockInWorld", "(" + blockPosType + ")Z");
        WorldTransformer.setBuildHeight(compiler, (CtBehavior)method);
        WorldTransformer.setBuildDepthLt(compiler, method);
        method = c.getMethod("getLight", "(" + blockPosType + ")I");
        WorldTransformer.setBuildHeight(compiler, (CtBehavior)method);
        WorldTransformer.setBuildDepthGt(compiler, method);
        method = c.getMethod("getLightAt", "(" + lightTypeType + blockPosType + ")I");
        WorldTransformer.setBuildDepthGt(compiler, method);
        method = c.getMethod("getNeighborLight", "(" + blockPosType + "Z)I");
        WorldTransformer.setBuildHeight(compiler, (CtBehavior)method);
        WorldTransformer.setMaxBlockY(compiler, (CtBehavior)method);
        WorldTransformer.setBuildDepthGt(compiler, method);
        method = c.getMethod("canBlockFreeze", "(" + blockPosType + "Z)Z");
        WorldTransformer.setBuildHeight(compiler, (CtBehavior)method);
        WorldTransformer.setBuildDepthLt(compiler, method);
        method = c.getMethod("canSnowAt", "(" + blockPosType + "Z)Z");
        WorldTransformer.setBuildHeight(compiler, (CtBehavior)method);
        WorldTransformer.setBuildDepthLt(compiler, method);
    }

    public static Integer getSeaLevel(World world) {
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null) {
            return chunkSystem.getSeaLevel(world);
        }
        return null;
    }

    public static Double getHorizonLevel(World world) {
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null) {
            return chunkSystem.getHorizonLevel(world);
        }
        return null;
    }

    public static Boolean updateLightingAt(World world, BlockPos pos) {
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null) {
            return chunkSystem.updateLightingAt(world, pos);
        }
        return null;
    }

    public static Boolean checkBlockRangeIsInWorld(World world, int minBlockX, int minBlockY, int minBlockZ, int maxBlockX, int maxBlockY, int maxBlockZ, boolean allowEmptyChunks) {
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null) {
            return chunkSystem.checkBlockRangeIsInWorld(world, minBlockX, minBlockY, minBlockZ, maxBlockX, maxBlockY, maxBlockZ, allowEmptyChunks);
        }
        return null;
    }

    public static boolean checkChunksExistForEntityUpdate(World world, int minBlockX, int minBlockY, int minBlockZ, int maxBlockX, int maxBlockY, int maxBlockZ, boolean allowEmptyChunks, World worldAgain, Entity entity, boolean forceUpdate) {
        Boolean result;
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null && (result = chunkSystem.checkEntityIsInWorld(world, entity, minBlockX, minBlockZ, maxBlockX, maxBlockZ, allowEmptyChunks)) != null) {
            return result;
        }
        return world.checkBlockRangeIsInWorld(minBlockX, minBlockY, minBlockZ, maxBlockX, maxBlockY, maxBlockZ, allowEmptyChunks);
    }

    private static void setBuildHeight(HookCompiler compiler, CtBehavior behavior) throws NotFoundException, CannotCompileException {
        compiler.replaceInt(behavior, 256, m_thisClass, "getBuildHeight");
    }

    private static void setMaxBlockY(HookCompiler compiler, CtBehavior behavior) throws NotFoundException, CannotCompileException {
        compiler.replaceInt(behavior, 255, m_thisClass, "getMaxBlockY");
    }

    private static void setBuildDepthGt(HookCompiler compiler, CtMethod method) throws NotFoundException, CannotCompileException {
        compiler.replaceGtZero((CtBehavior)method, m_thisClass, "getBuildDepth");
    }

    private static void setBuildDepthLt(HookCompiler compiler, CtMethod method) throws NotFoundException, CannotCompileException {
        compiler.replaceLtZero((CtBehavior)method, m_thisClass, "getBuildDepth");
    }

    public static int getMaxBlockY(World world) {
        Integer result;
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null && (result = chunkSystem.getMaxBlockY(world)) != null) {
            return result;
        }
        return 255;
    }

    public static int getBuildHeight(World world) {
        return WorldTransformer.getMaxBlockY(world) + 1;
    }

    public static int getBuildDepth(World world) {
        Integer result;
        ChunkSystem chunkSystem = M3L.instance.getRegistry().chunkSystem.get();
        if (chunkSystem != null && (result = chunkSystem.getMinBlockY(world)) != null) {
            return result;
        }
        return 0;
    }
}

