/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation.transformers;

import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.m3l.Side;
import cuchaz.m3l.classTransformation.ClassTransformer;
import cuchaz.m3l.classTransformation.HookCompiler;
import cuchaz.m3l.classTransformation.transformers.WorldTransformer;
import cuchaz.m3l.util.EntryFactory;
import cuchaz.m3l.util.Util;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.LightType;

public class ChunkCacheTransformer
implements ClassTransformer {
    private static ClassEntry m_thisClass = EntryFactory.getClassEntry(ChunkCacheTransformer.class);

    @Override
    public boolean meetsRequirements(CtClass c) {
        return c.getName().equals(ChunkCache.class.getName());
    }

    @Override
    public void compile(HookCompiler compiler, CtClass c, Side side) throws NotFoundException, CannotCompileException {
        String blockPosType = Util.getClassDesc(BlockPos.class);
        String blockStateType = Util.getClassDesc(IBlockState.class);
        String lightType = Util.getClassDesc(LightType.class);
        CtMethod method = c.getMethod("getBlockStateAt", "(" + blockPosType + ")" + blockStateType);
        ChunkCacheTransformer.setBuildHeight(compiler, (CtBehavior)method);
        ChunkCacheTransformer.setBuildDepthLt(compiler, method);
        method = c.getMethod("getLightForExt", "(" + lightType + blockPosType + ")I");
        ChunkCacheTransformer.setBuildHeight(compiler, (CtBehavior)method);
        ChunkCacheTransformer.setBuildDepthLt(compiler, method);
        method = c.getMethod("getLightForPos", "(" + lightType + blockPosType + ")I");
        ChunkCacheTransformer.setBuildHeight(compiler, (CtBehavior)method);
        ChunkCacheTransformer.setBuildDepthLt(compiler, method);
    }

    private static void setBuildHeight(HookCompiler compiler, CtBehavior behavior) throws NotFoundException, CannotCompileException {
        compiler.replaceInt(behavior, 256, m_thisClass, "getBuildHeight");
    }

    private static void setBuildDepthLt(HookCompiler compiler, CtMethod method) throws NotFoundException, CannotCompileException {
        compiler.replaceLtZero((CtBehavior)method, m_thisClass, "getBuildDepth");
    }

    public static int getBuildHeight(ChunkCache chunkCache) {
        return WorldTransformer.getBuildHeight(chunkCache.world);
    }

    public static int getBuildDepth(ChunkCache chunkCache) {
        return WorldTransformer.getBuildDepth(chunkCache.world);
    }
}

