/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation.transformers;

import cuchaz.m3l.Side;
import cuchaz.m3l.classTransformation.ClassTransformer;
import cuchaz.m3l.classTransformation.HookCompiler;
import cuchaz.m3l.util.Util;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;
import net.minecraft.world.biome.Biome;

public class BiomeGenBaseTransformer
implements ClassTransformer {
    @Override
    public boolean meetsRequirements(CtClass c) {
        return c.getName().equals(Biome.class.getName());
    }

    @Override
    public void compile(HookCompiler compiler, CtClass c, Side side) throws NotFoundException, CannotCompileException {
        compiler.insertBeforeBehavior((CtBehavior)c.getMethod("func_150568_d", "(I)" + Util.getClassDesc(Biome.class)), "$1 = " + this.getClass().getName() + ".mapBiomeId( $1 );");
    }

    public static int mapBiomeId(int id) {
        int largestId = BiomeGenBaseTransformer.getLargestBiomeId();
        if (id < 0) {
            id *= -1;
        }
        return id %= largestId + 1;
    }

    private static int getLargestBiomeId() {
        Biome[] biomes = Biome.getBiomeArray();
        int i = 0;
        while (i < biomes.length) {
            if (biomes[i] == null) {
                return i - 1;
            }
            ++i;
        }
        return 0;
    }
}

