/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cuchaz.enigma.analysis.JarClassIterator;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassNameReplacer;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.Signature;
import cuchaz.m3l.util.Logging;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.CtClass;
import javassist.CtMethod;
import org.slf4j.Logger;

public class SpongeImplementationMatcher {
    private static final Logger m_log = Logging.getLogger();
    private JarFile m_minecraftJar;
    private JarFile m_spongeApiJar;
    private Multimap<ClassEntry, MethodEntry> m_minecraftIndex;
    private Multimap<ClassEntry, MethodEntry> m_spongeIndex;
    private Multimap<ClassEntry, ClassEntry> m_matchesBySponge;
    private Multimap<ClassEntry, ClassEntry> m_matchesByMinecraft;

    public SpongeImplementationMatcher(JarFile minecraftJar, JarFile spongeApiJar) {
        int n;
        ClassEntry classEntry;
        this.m_minecraftJar = minecraftJar;
        this.m_spongeApiJar = spongeApiJar;
        this.m_minecraftIndex = HashMultimap.create();
        this.m_spongeIndex = HashMultimap.create();
        this.m_matchesBySponge = HashMultimap.create();
        this.m_matchesByMinecraft = HashMultimap.create();
        m_log.info("Indexing SpongeAPI interfaces and methods...");
        Enumeration<JarEntry> enumeration = this.m_spongeApiJar.entries();
        while (enumeration.hasMoreElements()) {
            CtClass c;
            JarEntry entry = enumeration.nextElement();
            String fileName = entry.getName();
            if (!fileName.endsWith(".class") || !(classEntry = new ClassEntry(fileName.substring(0, fileName.length() - 6))).getPackageName().startsWith("org/spongepowered/api") || !(c = JarClassIterator.getClass((JarFile)this.m_spongeApiJar, (ClassEntry)classEntry)).isInterface() || c.getDeclaredMethods().length <= 0) continue;
            CtMethod[] ctMethodArray = c.getDeclaredMethods();
            int n2 = ctMethodArray.length;
            n = 0;
            while (n < n2) {
                CtMethod method = ctMethodArray[n];
                this.m_spongeIndex.put((Object)classEntry, (Object)EntryFactory.getMethodEntry((CtMethod)method));
                ++n;
            }
        }
        m_log.info("Found {} SpongeAPI interfaces", (Object)this.m_spongeIndex.size());
        for (CtClass c : JarClassIterator.classes((JarFile)this.m_minecraftJar)) {
            classEntry = EntryFactory.getClassEntry((CtClass)c);
            CtMethod[] ctMethodArray = c.getDeclaredMethods();
            n = ctMethodArray.length;
            int n3 = 0;
            while (n3 < n) {
                CtMethod method = ctMethodArray[n3];
                this.m_minecraftIndex.put((Object)classEntry, (Object)EntryFactory.getMethodEntry((CtMethod)method));
                ++n3;
            }
        }
        m_log.info("Found {} Minecraft classes", (Object)this.m_minecraftIndex.size());
        m_log.info("Matching Minecraft classes to SpongeAPI interfaces...");
        this.match();
        m_log.info("Matching complete!");
    }

    private void match() {
        for (ClassEntry minecraftEntry : this.m_minecraftIndex.keySet()) {
            ClassEntry interfaceEntry;
            if (this.m_matchesByMinecraft.containsKey((Object)minecraftEntry) || (interfaceEntry = this.matchToSpongeInterface(minecraftEntry)) == null) continue;
            this.m_matchesBySponge.get((Object)interfaceEntry).add(minecraftEntry);
            this.m_matchesByMinecraft.put((Object)minecraftEntry, (Object)interfaceEntry);
            m_log.info("MATCH: {} -> {}", (Object)minecraftEntry, (Object)interfaceEntry);
        }
        m_log.info("Matches: {}/{}", (Object)this.m_matchesByMinecraft.size(), (Object)this.m_minecraftIndex.size());
    }

    private ClassEntry matchToSpongeInterface(ClassEntry minecraftEntry) {
        for (ClassEntry spongeEntry : this.m_matchesBySponge.keySet()) {
            if (!this.matchesInterface(minecraftEntry, spongeEntry)) continue;
            return spongeEntry;
        }
        return null;
    }

    private boolean matchesInterface(ClassEntry minecraftClassEntry, ClassEntry spongeClassEntry) {
        for (MethodEntry spongeMethodEntry : this.m_spongeIndex.get((Object)spongeClassEntry)) {
            if (this.matchesMethod(minecraftClassEntry, spongeMethodEntry)) continue;
            return false;
        }
        return true;
    }

    private boolean matchesMethod(ClassEntry minecraftClassEntry, MethodEntry spongeMethodEntry) {
        for (MethodEntry minecraftMethodEntry : this.m_minecraftIndex.get((Object)minecraftClassEntry)) {
            if (!this.methodsMatch(minecraftMethodEntry, spongeMethodEntry)) continue;
            return true;
        }
        return false;
    }

    private boolean methodsMatch(MethodEntry minecraftMethodEntry, MethodEntry spongeMethodEntry) {
        MethodEntry mapped = new MethodEntry(this.mapClass(minecraftMethodEntry.getClassEntry()), minecraftMethodEntry.getName(), new Signature(minecraftMethodEntry.getSignature(), new ClassNameReplacer(){

            public String replace(String className) {
                return SpongeImplementationMatcher.this.mapClass(className);
            }
        }));
        return mapped.equals(spongeMethodEntry);
    }

    private String mapClass(String in) {
        ClassEntry mapped = this.mapClass(new ClassEntry(in));
        if (mapped != null) {
            return mapped.getName();
        }
        return in;
    }

    private ClassEntry mapClass(ClassEntry in) {
        Collection mappedClasses = this.m_matchesByMinecraft.get((Object)in);
        if (mappedClasses.isEmpty()) {
            return in;
        }
        if (mappedClasses.size() == 1) {
            return (ClassEntry)mappedClasses.iterator().next();
        }
        throw new Error("TODO: implement checking when Minecraft classes implement multiple interfaces");
    }
}

