/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.m3l.classTransformation.hooks.BehaviorHook;
import cuchaz.m3l.classTransformation.hooks.ClassHook;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javassist.CtBehavior;
import javassist.CtClass;

public class HookLibrary {
    private ListMultimap<ClassEntry, ClassHook> m_classHooks = ArrayListMultimap.create();
    private ListMultimap<BehaviorEntry, BehaviorHook> m_behaviorHooks = ArrayListMultimap.create();

    public void addHook(ClassHook hook) {
        this.m_classHooks.get((Object)hook.getClassEntry()).add(hook);
    }

    public void addHook(BehaviorHook hook) {
        this.m_behaviorHooks.get((Object)hook.getBehaviorEntry()).add(hook);
    }

    public List<ClassHook> getHooks(CtClass c) {
        return this.m_classHooks.get((Object)EntryFactory.getClassEntry((CtClass)c));
    }

    public List<BehaviorHook> getHooks(CtBehavior behavior) {
        return this.m_behaviorHooks.get((Object)EntryFactory.getBehaviorEntry((CtBehavior)behavior));
    }

    public Iterable<ClassHook> classHooks() {
        return this.m_classHooks.values();
    }

    public Iterable<BehaviorHook> methodHooks() {
        return this.m_behaviorHooks.values();
    }

    public void write(OutputStream out) throws IOException {
        GZIPOutputStream gzipout = new GZIPOutputStream(out);
        ObjectOutputStream oout = new ObjectOutputStream(gzipout);
        oout.writeObject(this.m_classHooks);
        oout.writeObject(this.m_behaviorHooks);
        gzipout.finish();
    }

    public void read(InputStream in) throws IOException {
        try {
            ObjectInputStream oin = new ObjectInputStream(new GZIPInputStream(in));
            this.m_classHooks = (ListMultimap)oin.readObject();
            this.m_behaviorHooks = (ListMultimap)oin.readObject();
        }
        catch (ClassNotFoundException ex) {
            throw new Error(ex);
        }
    }
}

