/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l.classTransformation;

import com.google.common.collect.Lists;
import cuchaz.enigma.bytecode.ConstPoolEditor;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.Type;
import cuchaz.m3l.classTransformation.hooks.BehaviorHook;
import cuchaz.m3l.classTransformation.hooks.ClassHook;
import cuchaz.m3l.classTransformation.hooks.DoubleReplacementHook;
import cuchaz.m3l.classTransformation.hooks.GtZeroReplacementHook;
import cuchaz.m3l.classTransformation.hooks.InsertAfterVoidBehaviorHook;
import cuchaz.m3l.classTransformation.hooks.InsertBeforeBehaviorHook;
import cuchaz.m3l.classTransformation.hooks.InsertBeforeReturnHook;
import cuchaz.m3l.classTransformation.hooks.IntReplacementHook;
import cuchaz.m3l.classTransformation.hooks.LtZeroReplacementHook;
import cuchaz.m3l.classTransformation.hooks.ReplaceBehaviorHook;
import cuchaz.m3l.classTransformation.hooks.VirtualCallReplacementHook;
import cuchaz.m3l.classTransformation.hooks.VirtualCallThenArrayAccessReplacementHook;
import cuchaz.m3l.util.BytecodeTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.Descriptor;
import javassist.bytecode.MethodInfo;
import javassist.compiler.CompileError;
import javassist.compiler.Javac;

public class HookCompiler {
    private List<ClassHook> m_classHooks = Lists.newArrayList();
    private List<BehaviorHook> m_behaviorHooks = Lists.newArrayList();

    public Iterable<ClassHook> classHooks() {
        return this.m_classHooks;
    }

    public Iterable<BehaviorHook> behaviorHooks() {
        return this.m_behaviorHooks;
    }

    public int getNumHooks() {
        return this.m_classHooks.size() + this.m_behaviorHooks.size();
    }

    public void replaceBehavior(CtBehavior behavior) throws NotFoundException, CannotCompileException {
        this.m_behaviorHooks.add(new ReplaceBehaviorHook(behavior, this.compile(behavior)));
    }

    public void insertBeforeBehavior(CtBehavior behavior, String code) throws NotFoundException, CannotCompileException {
        this.m_behaviorHooks.add(new InsertBeforeBehaviorHook(behavior, this.compile(behavior, code)));
    }

    public void insertAfterVoidBehavior(CtBehavior behavior, String code) throws NotFoundException, CannotCompileException {
        if (behavior instanceof CtMethod && ((CtMethod)behavior).getReturnType() != CtClass.voidType) {
            throw new IllegalArgumentException(String.valueOf(behavior.getDeclaringClass().getName()) + "." + behavior.getName() + "() was not a void method!");
        }
        this.m_behaviorHooks.add(new InsertAfterVoidBehaviorHook(behavior, this.compile(behavior, code)));
    }

    public void insertBeforeReturn(CtBehavior behavior, String code) throws NotFoundException, CannotCompileException {
        this.m_behaviorHooks.add(new InsertBeforeReturnHook(behavior, this.compile(behavior, code)));
    }

    public void replaceInt(CtBehavior behavior, int val, ClassEntry replacementClassEntry, String replacementMethodName) throws NotFoundException, CannotCompileException {
        byte[] bytecode = this.compileInvokeStatic(behavior, replacementClassEntry, replacementMethodName, this.getThisArgs(behavior));
        this.m_behaviorHooks.add(new IntReplacementHook(behavior, val, bytecode));
    }

    private String getThisArgs(CtBehavior behavior) {
        return Modifier.isStatic((int)behavior.getModifiers()) ? "" : "this";
    }

    public void replaceDouble(CtBehavior behavior, double val, ClassEntry replacementClassEntry, String replacementMethodName) throws NotFoundException, CannotCompileException {
        byte[] bytecode = this.compileInvokeStatic(behavior, replacementClassEntry, replacementMethodName, this.getThisArgs(behavior));
        this.m_behaviorHooks.add(new DoubleReplacementHook(behavior, val, bytecode));
    }

    public void replaceGtZero(CtBehavior behavior, ClassEntry replacementClassEntry, String replacementMethodName) throws NotFoundException, CannotCompileException {
        byte[] bytecode = this.compileInvokeStatic(behavior, replacementClassEntry, replacementMethodName, this.getThisArgs(behavior));
        this.m_behaviorHooks.add(new GtZeroReplacementHook(behavior, bytecode));
    }

    public void replaceLtZero(CtBehavior behavior, ClassEntry replacementClassEntry, String replacementMethodName) throws NotFoundException, CannotCompileException {
        byte[] bytecode = this.compileInvokeStatic(behavior, replacementClassEntry, replacementMethodName, this.getThisArgs(behavior));
        this.m_behaviorHooks.add(new LtZeroReplacementHook(behavior, bytecode));
    }

    public void replaceVirtualCall(CtBehavior behavior, BehaviorEntry targetBehaviorCall, ClassEntry replacementClassEntry, String replacementMethodName) throws NotFoundException, CannotCompileException {
        this.replaceVirtualCall(behavior, targetBehaviorCall, replacementClassEntry, replacementMethodName, false);
    }

    public void replaceVirtualCall(CtBehavior behavior, BehaviorEntry targetBehaviorCall, ClassEntry replacementClassEntry, String replacementMethodName, boolean includeArguments) throws NotFoundException, CannotCompileException {
        ArrayList<Type> types = new ArrayList<Type>();
        types.add(new Type(targetBehaviorCall.getClassEntry()));
        for (Type type : targetBehaviorCall.getSignature().getArgumentTypes()) {
            types.add(type);
        }
        if (includeArguments) {
            BehaviorEntry behaviorEntry = EntryFactory.getBehaviorEntry((CtBehavior)behavior);
            if (!Modifier.isStatic((int)behavior.getModifiers())) {
                types.add(new Type(behaviorEntry.getClassEntry()));
            }
            for (Type type : behaviorEntry.getSignature().getArgumentTypes()) {
                types.add(type);
            }
        }
        StringBuilder buf = new StringBuilder();
        for (Type type : types) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            if (type.isClass()) {
                buf.append("(" + Descriptor.toJavaName((String)type.getClassEntry().getName()) + ")null");
                continue;
            }
            if (type.isArray()) {
                Type arrayType = type.getArrayType();
                if (arrayType.isClass()) {
                    buf.append("(" + Descriptor.toJavaName((String)arrayType.getClassEntry().getName()) + "[])null");
                    continue;
                }
                if (!arrayType.isPrimitive()) continue;
                buf.append("(" + arrayType.getPrimitive().name() + "[])null");
                continue;
            }
            if (!type.isPrimitive()) continue;
            if (type.getPrimitive() == Type.Primitive.Character) {
                buf.append("'0'");
                continue;
            }
            if (type.getPrimitive() == Type.Primitive.Boolean) {
                buf.append("false");
                continue;
            }
            buf.append("0");
        }
        byte[] bytecode = this.compileInvokeStatic(behavior, replacementClassEntry, replacementMethodName, buf.toString());
        this.m_behaviorHooks.add(new VirtualCallReplacementHook(behavior, bytecode, targetBehaviorCall, includeArguments));
    }

    public void replaceVirtualCallThenArrayAccess(CtBehavior behavior, BehaviorEntry targetBehaviorCall, ClassEntry replacementClassEntry, String replacementMethodName) throws NotFoundException, CannotCompileException {
        byte[] bytecode = this.compileInvokeStatic(behavior, replacementClassEntry, replacementMethodName, "null, 0");
        this.m_behaviorHooks.add(new VirtualCallThenArrayAccessReplacementHook(behavior, bytecode, targetBehaviorCall));
    }

    private byte[] compile(CtBehavior behavior, String code) throws NotFoundException, CannotCompileException {
        try {
            CtClass c = behavior.getDeclaringClass();
            MethodInfo info = behavior.getMethodInfo();
            CodeAttribute attribute = info.getCodeAttribute();
            Bytecode bytecode = new Bytecode(c.getClassFile().getConstPool(), 0, attribute.getMaxLocals() + 1);
            bytecode.setStackDepth(attribute.getMaxStack() + 1);
            Javac compiler = new Javac(bytecode, c);
            int numArgs = compiler.recordParams(behavior.getParameterTypes(), Modifier.isStatic((int)behavior.getModifiers()));
            compiler.recordParamNames(attribute, numArgs);
            compiler.recordLocalVariables(attribute, 0);
            compiler.recordReturnType(Descriptor.getReturnType((String)info.getDescriptor(), (ClassPool)c.getClassPool()), true);
            compiler.compileStmnt(code);
            bytecode = BytecodeTools.copyBytecodeToConstPool(ConstPoolEditor.newConstPool(), bytecode);
            return BytecodeTools.writeBytecode(bytecode);
        }
        catch (BadBytecode | CompileError ex) {
            throw new CannotCompileException(ex);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    private byte[] compile(CtBehavior behavior) throws NotFoundException, CannotCompileException {
        try {
            MethodInfo info = behavior.getMethodInfo();
            CodeAttribute attribute = info.getCodeAttribute();
            Bytecode bytecode = new Bytecode(info.getConstPool(), attribute.getMaxStack(), attribute.getMaxLocals());
            BytecodeTools.setBytecode(bytecode, attribute.getCode());
            BytecodeTools.setExceptionTable(bytecode, attribute.getExceptionTable());
            bytecode = BytecodeTools.copyBytecodeToConstPool(ConstPoolEditor.newConstPool(), bytecode);
            return BytecodeTools.writeBytecode(bytecode);
        }
        catch (BadBytecode ex) {
            throw new CannotCompileException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    private byte[] compileInvokeStatic(CtBehavior behavior, ClassEntry classEntry, String accessorName) throws NotFoundException, CannotCompileException {
        return this.compileInvokeStatic(behavior, classEntry, accessorName, "");
    }

    private byte[] compileInvokeStatic(CtBehavior behavior, ClassEntry classEntry, String accessorName, String vars) throws NotFoundException, CannotCompileException {
        try {
            String code = String.format("%s.%s(%s);", Descriptor.toJavaName((String)classEntry.getName()), accessorName, vars);
            byte[] encodedBytecode = this.compile(behavior, code);
            Bytecode bytecode = BytecodeTools.readBytecode(encodedBytecode);
            Bytecode newBytecode = new Bytecode(bytecode.getConstPool(), bytecode.getMaxStack(), bytecode.getMaxLocals());
            newBytecode.addGap(3);
            int i = 0;
            while (i < bytecode.length()) {
                int opcode = bytecode.read(i) & 0xFF;
                if (opcode == 184) {
                    newBytecode.write(0, opcode);
                    newBytecode.write(1, bytecode.read(i + 1) & 0xFF);
                    newBytecode.write(2, bytecode.read(i + 2) & 0xFF);
                    break;
                }
                ++i;
            }
            assert (newBytecode.length() == 3);
            assert ((newBytecode.read(0) & 0xFF) == 184);
            return BytecodeTools.writeBytecode(newBytecode);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }
}

