/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.m3l;

import cuchaz.enigma.analysis.JarClassIterator;
import cuchaz.enigma.bytecode.ClassRenamer;
import cuchaz.m3l.Constants;
import cuchaz.m3l.Side;
import cuchaz.m3l.classTransformation.ClassTransformer;
import cuchaz.m3l.classTransformation.ClassTransformerRegistry;
import cuchaz.m3l.classTransformation.HookCompiler;
import cuchaz.m3l.classTransformation.HookLibrary;
import cuchaz.m3l.classTransformation.hooks.BehaviorHook;
import cuchaz.m3l.classTransformation.hooks.ClassHook;
import cuchaz.m3l.util.Logging;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.jar.JarFile;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import org.slf4j.Logger;

public class MainCompileHooks {
    private static final Logger log = Logging.getLogger();

    public static void main(String[] args) throws Exception {
        try {
            if (args.length < 1) {
                throw new IllegalArgumentException("side is a required argument");
            }
            Side side = Side.get(args[0]);
            if (args.length < 2) {
                throw new IllegalArgumentException("pathToDeobfMinecraftJar is a required argument");
            }
            File jarMinecraft = new File(args[1]).getAbsoluteFile();
            if (!jarMinecraft.exists()) {
                throw new IllegalArgumentException("File not found: " + jarMinecraft.getPath());
            }
            try {
                MainCompileHooks.compile(Constants.getConfFile(Constants.getResourceHooks(side)), new JarFile(jarMinecraft), side);
            }
            catch (Throwable t) {
                t.printStackTrace(System.out);
            }
        }
        catch (IllegalArgumentException ex) {
            MainCompileHooks.printHelp();
        }
    }

    private static void printHelp() {
        System.out.println("Magic Mojo Mod Loader (M3L) - v1.8.3-0.2b");
        System.out.println("Hook compiler arguments:");
        System.out.println("\tside pathToDeobfMinecraftJar");
        System.out.println("where side is \"client\" or \"server\"");
        System.out.println("and pathToDeobfMinecraftJar is the path to either the deobfuscated client or server jar");
    }

    /*
     * WARNING - void declaration
     */
    private static void compile(File fileOut, JarFile jar, Side side) throws Exception {
        ClassPool classPool = new ClassPool();
        classPool.insertClassPath((ClassPath)new LoaderClassPath(MainCompileHooks.class.getClassLoader()));
        log.info("Scanning Minecraft classes...");
        int numClassesScanned = 0;
        HookCompiler precompiler = new HookCompiler();
        for (CtClass c : JarClassIterator.classes((JarFile)jar)) {
            ClassRenamer.moveAllClassesOutOfDefaultPackage((CtClass)c, (String)"none");
            for (ClassTransformer transformer : ClassTransformerRegistry.getTransformers()) {
                if (!transformer.meetsRequirements(c)) continue;
                log.info("Precompiling hooks for " + transformer.getClass().getSimpleName());
                transformer.compile(precompiler, c, side);
            }
            ++numClassesScanned;
        }
        log.info("Precompiled " + precompiler.getNumHooks() + " hooks from " + numClassesScanned + " minecraft classes!");
        HookLibrary library = new HookLibrary();
        for (ClassHook classHook : precompiler.classHooks()) {
            library.addHook(classHook);
        }
        for (BehaviorHook behaviorHook : precompiler.behaviorHooks()) {
            library.addHook(behaviorHook);
        }
        Throwable throwable = null;
        Iterator<Serializable> iterator = null;
        try (FileOutputStream out = new FileOutputStream(fileOut);){
            library.write(out);
        }
        catch (Throwable throwable2) {
            void var7_14;
            if (throwable == null) {
                Throwable throwable3 = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw var7_14;
        }
        log.info("Wrote precompiled hooks to:\n\t" + fileOut.getAbsolutePath());
    }
}

