/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.eventhandler;

import com.google.common.collect.ImmutableList;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.ListenerList;

public class ListenerList {
    private static ImmutableList<ListenerList> allLists = ImmutableList.of();
    private static int maxSize = 0;
    private ListenerList parent;
    private ListenerListInst[] lists = new ListenerListInst[0];

    public ListenerList() {
        this(null);
    }

    public ListenerList(ListenerList parent) {
        this.parent = parent;
        ListenerList.extendMasterList(this);
        this.resizeLists(maxSize);
    }

    private static synchronized void extendMasterList(ListenerList inst) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(allLists);
        builder.add((Object)inst);
        allLists = builder.build();
    }

    public static void resize(int max) {
        if (max <= maxSize) {
            return;
        }
        for (ListenerList list : allLists) {
            list.resizeLists(max);
        }
        maxSize = max;
    }

    public void resizeLists(int max) {
        int x;
        if (this.parent != null) {
            this.parent.resizeLists(max);
        }
        if (this.lists.length >= max) {
            return;
        }
        ListenerListInst[] newList = new ListenerListInst[max];
        for (x = 0; x < this.lists.length; ++x) {
            newList[x] = this.lists[x];
        }
        while (x < max) {
            newList[x] = this.parent != null ? new ListenerListInst(this, this.parent.getInstance(x), null) : new ListenerListInst(this, null);
            ++x;
        }
        this.lists = newList;
    }

    public static void clearBusID(int id) {
        for (ListenerList list : allLists) {
            list.lists[id].dispose();
        }
    }

    protected ListenerListInst getInstance(int id) {
        return this.lists[id];
    }

    public IEventListener[] getListeners(int id) {
        return this.lists[id].getListeners();
    }

    public void register(int id, EventPriority priority, IEventListener listener) {
        this.lists[id].register(priority, listener);
    }

    public void unregister(int id, IEventListener listener) {
        this.lists[id].unregister(listener);
    }

    public static void unregisterAll(int id, IEventListener listener) {
        for (ListenerList list : allLists) {
            list.unregister(id, listener);
        }
    }
}

